/*******************************************************************************
 * Copyright (c) 2007, 2023 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *     Semantum Oy - gitlab #972
 *******************************************************************************/
package org.simantics.diagram.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.chassis.ICanvasChassis;
import org.simantics.scenegraph.g2d.events.EventDebugPolicy;
import org.simantics.scenegraph.g2d.events.EventQueue;
import org.simantics.scenegraph.g2d.events.command.Command;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;

/**
 * A handler for the Eclipse Command framework that delegates ID of the command
 * that triggered the event to the {@link EventQueue} of the
 * {@link ICanvasContext} where the event occurred.
 */
public class CanvasCommandDelegate extends AbstractHandler {

    private final boolean DEBUG = EventDebugPolicy.CANVAS_COMMAND_DELEGATION;

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Event e = ((Event)event.getTrigger());
        CommandEvent ce = new CommandEvent(null, e != null ? e.time : 0L, new Command(event.getCommand().getId()));

        if (DEBUG)
            System.out.println(getClass().getSimpleName() + ": trigger event = " + e + " for command " + ce.command);

        if (e != null && e.widget instanceof ICanvasChassis) {
            ICanvasChassis chassis = (ICanvasChassis) e.widget;
            ICanvasContext canvas = chassis.getCanvasContext();
            if (canvas != null) {
                if (DEBUG)
                    System.out.println(getClass().getSimpleName() + ": sending command " + event.getCommand().getId() + " to " + chassis);
                canvas.getEventQueue().queueEvent( ce );
            }
        } else {
            ICanvasContext canvas = null;
            IWorkbenchPart part = HandlerUtil.getActiveEditor(event);
            if (part != null)
                canvas = (ICanvasContext) part.getAdapter(ICanvasContext.class);
            if (canvas == null) {
                part = HandlerUtil.getActivePart(event);
                if (part != null)
                    canvas = (ICanvasContext) part.getAdapter(ICanvasContext.class);
            }
            if (canvas != null) {
                if (DEBUG)
                    System.out.println(getClass().getSimpleName() + ": sending command " + event.getCommand().getId() + " to " + part);
                canvas.getEventQueue().queueEvent(ce);
            }
        }
        return null;
    }

}