package org.simantics.diagram.flag;

import java.util.Collection;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.function.All;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.template2d.ontology.Template2dResource;

public class IOTableUtil {
    public static IOTablesInfo getIOTablesInfo(ReadGraph graph, Resource diagram) throws DatabaseException {
        return graph.syncRequest(new ResourceRead<IOTablesInfo>(diagram) {
            @Override
            public IOTablesInfo perform(ReadGraph graph) throws DatabaseException {
                Resource template = All.getTemplateFromDiagram(graph, resource);
                if(template == null)
                    return IOTablesInfo.EMPTY;
                
                Layer0 L0 = Layer0.getInstance(graph);
                Template2dResource TEMPLATE2D = Template2dResource.getInstance(graph);
                DiagramResource DIA = DiagramResource.getInstance(graph);
                
                IOTablesInfo result = new IOTablesInfo();
                Collection<Resource> slotTables = graph.getObjects(template, L0.ConsistsOf);
                for (Resource slotTable : slotTables) {
                    if (!graph.isInstanceOf(slotTable, TEMPLATE2D.FlagTable))
                        continue;
                    String name = graph.getPossibleRelatedValue(slotTable, L0.HasName, Bindings.STRING);
                    if (name == null)
                        continue;
                    Float width = graph.getPossibleRelatedValue(slotTable, TEMPLATE2D.FlagTable_HasWidth, Bindings.FLOAT);
                    Float rowHeight = graph.getPossibleRelatedValue(slotTable, TEMPLATE2D.FlagTable_HasRowHeigth, Bindings.FLOAT);
                    double[] transform = graph.getPossibleRelatedValue2(slotTable, DIA.Scenegraph_Composite_transform, Bindings.getBindingUnchecked(double[].class));
                    if(width == null || rowHeight == null || transform == null)
                        continue;
                    result.tables.add(new IOTableInfo(name, transform[4], transform[5], width, rowHeight));
                }
                return result;
            }
        });
    }
    
    public static boolean bindFlagToTable(WriteGraph graph, Resource diagram, Resource flagResource, double flagX, double flagY) throws DatabaseException {
        IOTablesInfo ioTablesInfo = IOTableUtil.getIOTablesInfo(graph, diagram);
        return ioTablesInfo.updateBinding(graph, DiagramResource.getInstance(graph), flagResource, flagX, flagY);
    }
}
