package org.simantics.diagram.elements;

import java.awt.geom.Rectangle2D;

/**
 * @author Antti Villberg
 * @since 1.31.0
 */
class EditorStateStatic {

	Rectangle2D verticalDimensions = null;
	double termStringWidth = 0;
	String textElementId = null;

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((textElementId == null) ? 0 : textElementId.hashCode());
		result = prime * result + ((verticalDimensions == null) ? 0 : verticalDimensions.hashCode());
		long temp;
		temp = Double.doubleToLongBits(termStringWidth);
		result = prime * result + (int) (temp ^ (temp >>> 32));
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		EditorStateStatic other = (EditorStateStatic) obj;
		if (textElementId == null) {
			if (other.textElementId != null)
				return false;
		} else if (!textElementId.equals(other.textElementId))
			return false;
		if (verticalDimensions == null) {
			if (other.verticalDimensions != null)
				return false;
		} else if (!verticalDimensions.equals(other.verticalDimensions))
			return false;
		if (Double.doubleToLongBits(termStringWidth) != Double.doubleToLongBits(other.termStringWidth))
			return false;
		return true;
	}

}