/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.content;

import org.simantics.g2d.diagram.handler.Topology.Terminal;
import org.simantics.g2d.element.IElement;

/**
 * @author Tuukka Lehtonen
 */
public class DesignatedTerminal {
    public final IElement element;
    public final Terminal terminal;

    public DesignatedTerminal(IElement element, Terminal terminal) {
        if (element == null)
            throw new NullPointerException("null element");
        if (terminal == null)
            throw new NullPointerException("null terminal");

        this.element = element;
        this.terminal = terminal;
    }
}
