package org.simantics.diagram.adapter;

import java.util.Collection;
import java.util.Set;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.impl.DefaultPasteHandler;
import org.simantics.db.layer0.util.SimanticsClipboard.Representation;
import org.simantics.diagram.internal.Activator;
import org.simantics.graph.db.IImportAdvisor2;
import org.simantics.layer0.Layer0;
import org.simantics.scenegraph.ontology.ScenegraphResources;

/**
 * @author Teemu M&auml;t&auml;sniemi
 * @author Tuukka Lehtonen
 */
public class ScenegraphCompositePasteHandler extends DefaultPasteHandler {

	int copied;

	public ScenegraphCompositePasteHandler(Resource resource) {
		super(resource);
	}

	@Override
	public void onPasteBegin(WriteGraph graph) {
		copied = 0;
	}

	@Override
	public void onPaste(WriteGraph graph, IImportAdvisor2 advisor, Set<Representation> representations) {
		final Layer0 L0 = Layer0.getInstance(graph);
		final ScenegraphResources SG = ScenegraphResources.getInstance(graph);

		try {
			final Resource parent = advisor.getTarget();
			if (parent == null)
				return;

			final Collection<Resource> roots = advisor.getRoots();
			if (roots == null || roots.isEmpty())
				return;

			// Validate that the pasted roots are scene graph nodes.
			for (Resource root : roots) {
				if (!graph.isInstanceOf(root, SG.Node))
					return;
			}

			final Resource list = graph.syncRequest(new UniqueRead<Resource>() {
				@Override
				public Resource perform(ReadGraph g) throws DatabaseException {
					Resource res = g.getPossibleObject(parent, SG.Node_children);
					return (res == null || !g.isInstanceOf(res, L0.List)) ? null : res;
				}
			});

			if (list == null)
				return;

			ListUtils.insertBack(graph, list, roots);
			copied += roots.size();

		} catch (DatabaseException e) {
			Activator.getDefault().getLog().log(new Status(IStatus.ERROR, Activator.PLUGIN_ID, "Failed to attach copied scene graph nodes to target composite node, see exception for details.", e));
		}
	}

	@Override
	public void onPasteEnd(WriteGraph graph) {
		if (copied > 0) {
			try {
				CommentMetadata cm = graph.getMetadata(CommentMetadata.class);
				graph.addMetadata(cm.add("Copy " + copied + " scene graph nodes."));
			} catch (DatabaseException e) {
				Activator.getDefault().getLog().log(new Status(IStatus.ERROR, Activator.PLUGIN_ID, "Failed to attach metadata to commit, see exception for details.", e));
			}
		}
	}

}
