/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.adapter;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.BinaryAsyncRead;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;

/**
 * @author Tuukka Lehtonen
 * 
 * @see CreateElementClassRequest
 * @see NodeRequest
 * @see ConnectionRequest
 */
class GetElementClassRequest extends BinaryAsyncRead<Resource, ICanvasContext, ElementClass> {

    private final ElementFactory elementFactory;
    private final IDiagram       diagram;

    public GetElementClassRequest(ElementFactory elementFactory, Resource element, ICanvasContext canvas, IDiagram diagram) {
        super(element, canvas);
        if (elementFactory == null)
            throw new IllegalArgumentException("elementFactory == null for " + element + " in diagram " + diagram + " with context " + canvas);
        this.elementFactory = elementFactory; 
        this.diagram = diagram;
    }

    @Override
    public void perform(AsyncReadGraph graph, AsyncProcedure<ElementClass> procedure) {
        elementFactory.getClass(graph, parameter2, diagram, parameter, procedure);
    }

}