/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.adapter;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.diagram.profile.StyleBase;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.operation.Layer0X;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.profile.EvaluationContext;
import org.simantics.scenegraph.profile.common.ProfileVariables;
import org.simantics.structural.stubs.StructuralResource2;

/**
 * @author Antti Villberg
 */
public class ExpressionStyle extends StyleBase<Map<String, Object>> {

	final Resource style;

	public ExpressionStyle(Resource style) {
		this.style = style;
	}

	@Override
	public Map<String, Object> calculateStyle(ReadGraph graph, Resource runtimeDiagram, Resource entry, Resource element, Variable activeVariable) throws DatabaseException {

		//System.err.println("calculateExpressionStyle " + activeVariable.getURI(graph));

		Layer0 L0 = Layer0.getInstance(graph);
		Layer0X L0X = Layer0X.getInstance(graph);
		DiagramResource DIA = DiagramResource.getInstance(graph);
		ModelingResources MOD = ModelingResources.getInstance(graph);
		StructuralResource2 SR = StructuralResource2.getInstance(graph);
		
		String key = graph.getPossibleRelatedValue(style, DIA.HasVariableName, Bindings.STRING);
		String expression = graph.getPossibleRelatedValue(style, L0X.HasExpression, Bindings.STRING);
		//System.out.println(key + ": " + expression);

		Resource module = graph.getPossibleObject(element, MOD.ElementToComponent);
		if (module == null)
			return null;

		Resource svg = null;
		Resource elementType = graph.getPossibleType(element, L0.Entity);
		if(elementType == null) return null;
		Resource definition = graph.getPossibleObject(elementType, SR.IsDefinedBy);
		if(definition == null) return null;
		List<Resource> items = OrderedSetUtils.toList(graph, definition);
		if(items == null) return null;
		for(Resource item : items) {
			if(graph.isInstanceOf(item, DIA.AnimatedSVGElement)) {
				svg = item;
				break;
			}
		}
		if(svg == null) return null;

		String moduleName = graph.getPossibleRelatedValue(module, L0.HasName, Bindings.STRING);
		if (moduleName == null)
			return null;

		Variable moduleVariable = activeVariable.getChild(graph, moduleName);

		//System.err.println("mv " + moduleVariable.getURI(graph));

		Object value = moduleVariable.getPossiblePropertyValue(graph, expression);
		Map<String, Object> values = Collections.singletonMap(key, value);
		
//		for(Resource desc : graph.getObjects(svg, DIA.HasConfigurationVariable)) {
//			String name = graph.getRelatedValue(desc, L0.HasName);
//			System.err.println("name=" + name);
//			String formula = graph.getRelatedValue(desc, L0X.HasExpression);
//			Object value = moduleVariable.getPossiblePropertyValue(graph, formula);
//			System.err.println(name + " => " + formula + " => " + value);
//			values.put(name, value);
//		}

		return values;

	}

	@Override
	public void applyStyleForNode(EvaluationContext evaluationContext, INode node, Map<String, Object> values) {
	    //System.out.println(this + ": apply values " + values);
	    if (values == null)
	        return;

	    ProfileVariables.claimNodeProperty(node, "valuezz", values, evaluationContext);
	    
//	    Variables.set(element, "valuezz", values, observer);
////	    for(Map.Entry<String, Object> entry : values.entrySet()) {
////	        Variables.set(element, entry.getKey(), entry.getValue(), observer);
////	    }
//
//	    PropertySetter setter = element.getElementClass().getAtMostOneItemOfClass(PropertySetter.class);
//	    if (setter != null)
//	        setter.syncPropertiesToNode(element);
	}

	@Override
	protected void cleanupStyleForNode(EvaluationContext observer, INode node) {
	    ProfileVariables.init(node, observer);
	}

	@Override
	public String toString() {
		return "Expression";
	}

}
