package org.simantics.diagram.adapter;

import java.util.HashMap;
import java.util.Map;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.diagram.stubs.DiagramResource;

class ElementParameterRequest extends ResourceRead<Map<String,Object>> {

	protected ElementParameterRequest(Resource resource) {
		super(resource);
	}

	@Override
	public Map<String, Object> perform(ReadGraph graph) throws DatabaseException {
		Variable var = Variables.getPossibleVariable(graph, resource);
		if(var == null) return null;
		Map<String,Object> result = null;
		for(Variable property : var.getProperties(graph, DiagramResource.URIs.DefinedElement_Parameter)) {
			Object value = property.getPossibleValue(graph);
			if(value != null) {
				if(result == null) result = new HashMap<>();
				result.put(property.getName(graph), value);
			}
		}
		return result;
	}

}