/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.adapter;

import org.simantics.db.Resource;
import org.simantics.diagram.connection.ConnectionSegmentEnd;
import org.simantics.diagram.connection.ConnectionSegmentType;

public class ConnectionInfo {

    public Resource connectionType;
    public Resource connection;
    public ConnectionSegmentEnd firstEnd;
    public ConnectionSegmentEnd secondEnd;
    public ConnectionSegmentType segmentType;

    public boolean isValid() {
        return firstEnd != null || secondEnd != null || segmentType != null;
    }

    @Override
    public String toString() {
        return "[type=" + connectionType + ", connection=" + connection
                + ", (" + firstEnd + " <-> " + secondEnd + ") => "
                + segmentType + "]";
    }

}
