/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.services.adaption;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.simantics.db.services.adaption.AdapterType;
import org.simantics.db.services.adaption.CachedParameterDefinition;

public class CachedAdapterDefinition
implements Serializable {
    private static final long serialVersionUID = 1L;
    public AdapterType type;
    public long typeResourceId;
    public String targetInterface;
    public String adapterClass;
    public String contextClass;
    public String constructor;
    public List<CachedParameterDefinition> parameters = new ArrayList<CachedParameterDefinition>();
    public String bundleSymbolicName;
    public String installerClassName;
    public String sourceFile;

    public static CachedAdapterDefinition forBaseType(long typeResourceId, String targetInterface, String bundleSymbolicName, String sourceFile) {
        CachedAdapterDefinition def = new CachedAdapterDefinition();
        def.type = AdapterType.BASE_TYPE;
        def.typeResourceId = typeResourceId;
        def.targetInterface = targetInterface;
        def.bundleSymbolicName = bundleSymbolicName;
        def.sourceFile = sourceFile;
        return def;
    }

    public static CachedAdapterDefinition forType(long typeResourceId, String targetInterface, String adapterClass, String constructor, List<CachedParameterDefinition> parameters, String bundleSymbolicName, String sourceFile) {
        CachedAdapterDefinition def = new CachedAdapterDefinition();
        def.type = AdapterType.TYPE;
        def.typeResourceId = typeResourceId;
        def.targetInterface = targetInterface;
        def.adapterClass = adapterClass;
        def.constructor = constructor;
        def.parameters = parameters != null ? parameters : new ArrayList();
        def.bundleSymbolicName = bundleSymbolicName;
        def.sourceFile = sourceFile;
        return def;
    }

    public static CachedAdapterDefinition forResource(long resourceId, String targetInterface, String adapterClass, String constructor, List<CachedParameterDefinition> parameters, String bundleSymbolicName, String sourceFile) {
        CachedAdapterDefinition def = new CachedAdapterDefinition();
        def.type = AdapterType.RESOURCE;
        def.typeResourceId = resourceId;
        def.targetInterface = targetInterface;
        def.adapterClass = adapterClass;
        def.constructor = constructor;
        def.parameters = parameters != null ? parameters : new ArrayList();
        def.bundleSymbolicName = bundleSymbolicName;
        def.sourceFile = sourceFile;
        return def;
    }

    public static CachedAdapterDefinition forAdapterClass(long typeResourceId, String targetInterface, String adapterClass, String contextClass, String bundleSymbolicName, String sourceFile) {
        CachedAdapterDefinition def = new CachedAdapterDefinition();
        def.type = AdapterType.ADAPTER_CLASS;
        def.typeResourceId = typeResourceId;
        def.targetInterface = targetInterface;
        def.adapterClass = adapterClass;
        def.contextClass = contextClass;
        def.bundleSymbolicName = bundleSymbolicName;
        def.sourceFile = sourceFile;
        return def;
    }

    public static CachedAdapterDefinition forInstaller(String installerClassName, String bundleSymbolicName, String sourceFile) {
        CachedAdapterDefinition def = new CachedAdapterDefinition();
        def.type = AdapterType.INSTALLER;
        def.installerClassName = installerClassName;
        def.bundleSymbolicName = bundleSymbolicName;
        def.sourceFile = sourceFile;
        return def;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CachedAdapterDefinition[type=").append((Object)this.type);
        sb.append(", targetInterface=").append(this.targetInterface);
        sb.append(", adapterClass=").append(this.adapterClass);
        if (this.typeResourceId != 0L) {
            sb.append(", typeResourceId=").append(this.typeResourceId);
        }
        if (this.contextClass != null) {
            sb.append(", contextClass=").append(this.contextClass);
        }
        if (this.constructor != null) {
            sb.append(", constructor=").append(this.constructor);
        }
        if (this.installerClassName != null) {
            sb.append(", installerClassName=").append(this.installerClassName);
        }
        sb.append(", bundle=").append(this.bundleSymbolicName);
        sb.append(", source=").append(this.sourceFile);
        sb.append("]");
        return sb.toString();
    }
}

