/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.services.adaption;

import java.io.File;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.adaption.Adapter;
import org.simantics.db.adaption.AdapterInstaller;
import org.simantics.db.adaption.AdaptionService;
import org.simantics.db.common.primitiverequest.PossibleResource;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.db.services.adaption.AdapterCacheManager;
import org.simantics.db.services.adaption.CachedAdapterDefinition;
import org.simantics.db.services.adaption.CachedParameterDefinition;
import org.simantics.db.services.adaption.ParameterType;
import org.simantics.db.services.adaption.reflection.AdaptingDynamicAdapter2;
import org.simantics.db.services.adaption.reflection.AtMostOneRelatedResource2;
import org.simantics.db.services.adaption.reflection.ConstantAdapter;
import org.simantics.db.services.adaption.reflection.GraphObject2;
import org.simantics.db.services.adaption.reflection.IDynamicAdapter2;
import org.simantics.db.services.adaption.reflection.OrderedSetResources2;
import org.simantics.db.services.adaption.reflection.ReflectionAdapter2;
import org.simantics.db.services.adaption.reflection.RelatedResources2;
import org.simantics.db.services.adaption.reflection.SingleRelatedResource2;
import org.simantics.db.services.adaption.reflection.StaticMethodAdapter;
import org.simantics.db.services.adaption.reflection.ThisResource2;
import org.simantics.scl.reflection.OntologyVersions;
import org.simantics.utils.FileUtils;
import org.simantics.utils.threads.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class AdapterRegistry2 {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdapterRegistry2.class);
    public static final String ADAPTERS_FILE = "adapters.xml";
    public static final String ADAPTERS = "adapters";
    public static final String ADAPTER = "adapter";
    public static final String TARGET = "target";
    public static final String BASE_TYPE = "baseType";
    public static final String TYPE = "type";
    public static final String RESOURCE = "resource";
    public static final String URI = "uri";
    public static final String INTERFACE = "interface";
    public static final String CLASS = "class";
    public static final String ADAPTER_CLASS = "adapterClass";
    public static final String CONTEXT_CLASS = "contextClass";
    public static final String INSTALLER = "installer";
    public static final String CONSTRUCTOR = "constructor";
    ConcurrentHashMap<AdapterInstaller, String> installerSources = new ConcurrentHashMap();
    Collection<Exception> exceptions = new ArrayList<Exception>();
    List<CachedAdapterDefinition> cacheDefinitions = new ArrayList<CachedAdapterDefinition>();
    boolean buildingCache = false;

    private void addInstaller(AdapterInstaller installer, String sourceDesc) {
        this.installerSources.put(installer, sourceDesc);
    }

    private static void handleException(Exception e, String fileName) {
        LOGGER.error("At {}", (Object)fileName, (Object)e);
    }

    private void handleException(Throwable e, AdapterInstaller installer) {
        String desc = this.installerSources.get(installer);
        LOGGER.error("At {}, installer {}", new Object[]{desc, installer, e});
    }

    private void handleAdaptersDocument(Loader b, Document doc, String fileName) {
        try {
            Element node = doc.getDocumentElement();
            if (node.getNodeName().equals(ADAPTERS)) {
                NodeList nodeList = node.getChildNodes();
                int i = 0;
                while (i < nodeList.getLength()) {
                    Node n = nodeList.item(i);
                    if (n.getNodeName().equals(TARGET)) {
                        this.handleTarget(b, n, fileName);
                    } else if (n.getNodeName().equals(INSTALLER)) {
                        this.handleInstaller(b, n, fileName);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            AdapterRegistry2.handleException(e, fileName);
        }
    }

    private void handleTarget(Loader b, Node node, String fileName) {
        try {
            Class<?> interface_ = b.loadClass(node.getAttributes().getNamedItem(INTERFACE).getNodeValue());
            NodeList nodeList = node.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                Node n = nodeList.item(i);
                String nodeName = n.getNodeName();
                if (nodeName.equals(BASE_TYPE)) {
                    this.handleBaseType(b, interface_, n, fileName);
                } else if (nodeName.equals(TYPE)) {
                    this.handleType(b, interface_, n, fileName);
                } else if (nodeName.equals(ADAPTER)) {
                    this.handleAdapter(b, interface_, n, fileName);
                } else if (nodeName.equals(RESOURCE)) {
                    this.handleResource(b, interface_, n, fileName);
                }
                ++i;
            }
        }
        catch (Exception e) {
            AdapterRegistry2.handleException(e, fileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleInstaller(Loader b, Node node, String fileName) {
        block5: {
            try {
                String installerClassName = node.getAttributes().getNamedItem(CLASS).getNodeValue();
                AdapterInstaller installer = b.loadClass(installerClassName).asSubclass(AdapterInstaller.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.addInstaller(installer, fileName);
                if (!this.buildingCache) break block5;
                CachedAdapterDefinition def = CachedAdapterDefinition.forInstaller(installerClassName, b.getBundle() != null ? b.getBundle().getSymbolicName() : "unknown", fileName);
                List<CachedAdapterDefinition> list = this.cacheDefinitions;
                synchronized (list) {
                    this.cacheDefinitions.add(def);
                }
            }
            catch (Exception e) {
                AdapterRegistry2.handleException(e, fileName);
            }
        }
    }

    private <T> void handleResource(final Loader b, final Class<T> interface_, final Node node, final String fileName) {
        try {
            NamedNodeMap attr = node.getAttributes();
            final String uri = attr.getNamedItem(URI).getNodeValue();
            final String className = attr.getNamedItem(CLASS).getNodeValue();
            Node constructorNode = attr.getNamedItem(CONSTRUCTOR);
            final String constructor = constructorNode == null ? null : constructorNode.getNodeValue();
            this.addInstaller(new AdapterInstaller(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void install(ReadGraph g, AdaptionService service) throws Exception {
                    Class clazz = b.loadClass(className).asSubclass(interface_);
                    List<IDynamicAdapter2> parameters = AdapterRegistry2.this.readParameters(g, node, b);
                    IDynamicAdapter2[] parameterArray = parameters.toArray(new IDynamicAdapter2[parameters.size()]);
                    Resource r = (Resource)g.syncRequest((Read)new PossibleResource(uri), (AsyncProcedure)TransientCacheAsyncListener.instance());
                    service.addInstanceAdapter(r, interface_, constructor == null ? new ReflectionAdapter2(clazz, parameterArray) : new StaticMethodAdapter(clazz, constructor, parameterArray));
                    if (AdapterRegistry2.this.buildingCache && r != null) {
                        List<CachedParameterDefinition> cachedParams = AdapterRegistry2.this.buildCachedParameters(g, node, b);
                        CachedAdapterDefinition def = CachedAdapterDefinition.forResource(r.getResourceId(), interface_.getName(), className, constructor, cachedParams, b.getBundle() != null ? b.getBundle().getSymbolicName() : "unknown", fileName);
                        List<CachedAdapterDefinition> list = AdapterRegistry2.this.cacheDefinitions;
                        synchronized (list) {
                            AdapterRegistry2.this.cacheDefinitions.add(def);
                        }
                    }
                }
            }, fileName);
        }
        catch (Exception e) {
            AdapterRegistry2.handleException(e, fileName);
        }
    }

    private <T> void handleType(final Loader b, final Class<T> interface_, final Node node, final String fileName) {
        try {
            NamedNodeMap attr = node.getAttributes();
            final String uri = attr.getNamedItem(URI).getNodeValue();
            Node constructorNode = attr.getNamedItem(CONSTRUCTOR);
            final String constructor = constructorNode == null ? null : constructorNode.getNodeValue();
            final String className = attr.getNamedItem(CLASS).getNodeValue();
            this.addInstaller(new AdapterInstaller(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void install(ReadGraph g, AdaptionService service) throws Exception {
                    block6: {
                        try {
                            Class clazz = b.loadClass(className).asSubclass(interface_);
                            List<IDynamicAdapter2> parameters = AdapterRegistry2.this.readParameters(g, node, b);
                            IDynamicAdapter2[] parameterArray = parameters.toArray(new IDynamicAdapter2[parameters.size()]);
                            Resource typeResource = g.getResource(uri);
                            service.addAdapter(typeResource, interface_, constructor == null ? new ReflectionAdapter2(clazz, parameterArray) : new StaticMethodAdapter(clazz, constructor, parameterArray));
                            if (!AdapterRegistry2.this.buildingCache) break block6;
                            List<CachedParameterDefinition> cachedParams = AdapterRegistry2.this.buildCachedParameters(g, node, b);
                            CachedAdapterDefinition def = CachedAdapterDefinition.forType(typeResource.getResourceId(), interface_.getName(), className, constructor, cachedParams, b.getBundle() != null ? b.getBundle().getSymbolicName() : "unknown", fileName);
                            List<CachedAdapterDefinition> list = AdapterRegistry2.this.cacheDefinitions;
                            synchronized (list) {
                                AdapterRegistry2.this.cacheDefinitions.add(def);
                            }
                        }
                        catch (Error t) {
                            LOGGER.error("Failed to adapt {}", (Object)interface_.getName(), (Object)t);
                            throw t;
                        }
                        catch (RuntimeException t) {
                            LOGGER.error("Failed to adapt {}", (Object)interface_.getName(), (Object)t);
                            throw t;
                        }
                    }
                }
            }, fileName);
        }
        catch (Exception e) {
            AdapterRegistry2.handleException(e, fileName);
        }
    }

    private List<CachedParameterDefinition> buildCachedParameters(ReadGraph g, Node node, Loader b) throws DatabaseException, DOMException {
        ArrayList<CachedParameterDefinition> cachedParams = new ArrayList<CachedParameterDefinition>();
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node n = nodeList.item(i);
            if (n.getNodeType() == 1) {
                NamedNodeMap attr = n.getAttributes();
                CachedParameterDefinition cached = null;
                if (n.getNodeName().equals("this")) {
                    cached = new CachedParameterDefinition(ParameterType.THIS);
                } else if (n.getNodeName().equals("graph")) {
                    cached = new CachedParameterDefinition(ParameterType.GRAPH);
                } else if (n.getNodeName().equals("bundle")) {
                    cached = new CachedParameterDefinition(ParameterType.BUNDLE);
                    Node fc = n.getFirstChild();
                    if (fc != null) {
                        cached.bundleId = fc.getNodeValue();
                    }
                } else if (n.getNodeName().equals("related")) {
                    uri = attr.getNamedItem(URI).getNodeValue();
                    cached = new CachedParameterDefinition(ParameterType.RELATED, g.getResource(uri).getResourceId());
                } else if (n.getNodeName().equals("orderedSet")) {
                    uri = attr.getNamedItem(URI).getNodeValue();
                    cached = new CachedParameterDefinition(ParameterType.ORDERED_SET, g.getResource(uri).getResourceId());
                } else if (n.getNodeName().equals("single")) {
                    uri = attr.getNamedItem(URI).getNodeValue();
                    cached = new CachedParameterDefinition(ParameterType.SINGLE, g.getResource(uri).getResourceId());
                } else if (n.getNodeName().equals("atMostOne")) {
                    uri = attr.getNamedItem(URI).getNodeValue();
                    cached = new CachedParameterDefinition(ParameterType.AT_MOST_ONE, g.getResource(uri).getResourceId());
                } else if (n.getNodeName().equals("string")) {
                    cached = new CachedParameterDefinition(ParameterType.STRING, n.getFirstChild().getNodeValue());
                }
                if (cached != null) {
                    Node toNode = attr.getNamedItem("to");
                    if (toNode != null) {
                        cached.adaptTo = toNode.getNodeValue();
                    }
                    cachedParams.add(cached);
                }
            }
            ++i;
        }
        return cachedParams;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<IDynamicAdapter2> readParameters(ReadGraph g, Node node, Loader b) throws DatabaseException, DOMException, ClassNotFoundException {
        NodeList nodeList = node.getChildNodes();
        ArrayList<IDynamicAdapter2> parameters = new ArrayList<IDynamicAdapter2>();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node n = nodeList.item(i);
            if (n.getNodeType() == 1) {
                NamedNodeMap attr = n.getAttributes();
                IDynamicAdapter2 da = null;
                if (n.getNodeName().equals("this")) {
                    da = ThisResource2.INSTANCE;
                } else if (n.getNodeName().equals("graph")) {
                    da = GraphObject2.INSTANCE;
                } else if (n.getNodeName().equals("bundle")) {
                    String bundleId = null;
                    Node fc = n.getFirstChild();
                    if (fc != null) {
                        bundleId = fc.getNodeValue();
                    }
                    if (bundleId == null) {
                        da = new ConstantAdapter(Bundle.class, b.getBundle());
                    } else {
                        Bundle ob = Platform.getBundle((String)bundleId);
                        if (ob == null) throw new DOMException(8, "bundle '" + bundleId + "' not found");
                        da = new ConstantAdapter(Bundle.class, ob);
                    }
                } else if (n.getNodeName().equals("related")) {
                    da = new RelatedResources2(g.getResource(attr.getNamedItem(URI).getNodeValue()));
                } else if (n.getNodeName().equals("orderedSet")) {
                    da = new OrderedSetResources2(g.getResource(attr.getNamedItem(URI).getNodeValue()));
                } else if (n.getNodeName().equals("single")) {
                    da = new SingleRelatedResource2(g.getResource(attr.getNamedItem(URI).getNodeValue()));
                } else if (n.getNodeName().equals("atMostOne")) {
                    da = new AtMostOneRelatedResource2(g.getResource(attr.getNamedItem(URI).getNodeValue()));
                } else if (n.getNodeName().equals("string")) {
                    da = new ConstantAdapter(String.class, n.getFirstChild().getNodeValue());
                }
                Node toNode = attr.getNamedItem("to");
                if (toNode != null) {
                    String to = toNode.getNodeValue();
                    da = new AdaptingDynamicAdapter2(da, b.loadClass(to));
                }
                parameters.add(da);
            }
            ++i;
        }
        return parameters;
    }

    private <T> void handleAdapter(final Loader b, final Class<T> interface_, Node node, final String fileName) {
        try {
            NamedNodeMap attr = node.getAttributes();
            final String uri = attr.getNamedItem(URI).getNodeValue();
            final String clazz = attr.getNamedItem(ADAPTER_CLASS).getNodeValue();
            Node contextNode = attr.getNamedItem(CONTEXT_CLASS);
            final String contextClassName = contextNode != null ? contextNode.getNodeValue() : null;
            final Class<Resource> contextClass = contextClassName != null ? b.loadClass(contextClassName) : Resource.class;
            this.addInstaller(new AdapterInstaller(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void install(ReadGraph g, AdaptionService service) throws Exception {
                    Resource typeResource = g.getResource(uri);
                    service.addAdapter(typeResource, interface_, contextClass, b.loadClass(clazz).asSubclass(Adapter.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    if (AdapterRegistry2.this.buildingCache) {
                        CachedAdapterDefinition def = CachedAdapterDefinition.forAdapterClass(typeResource.getResourceId(), interface_.getName(), clazz, contextClassName, b.getBundle() != null ? b.getBundle().getSymbolicName() : "unknown", fileName);
                        List<CachedAdapterDefinition> list = AdapterRegistry2.this.cacheDefinitions;
                        synchronized (list) {
                            AdapterRegistry2.this.cacheDefinitions.add(def);
                        }
                    }
                }
            }, fileName);
        }
        catch (Exception e) {
            AdapterRegistry2.handleException(e, fileName);
        }
    }

    private <T> void handleBaseType(final Loader b, final Class<T> interface_, Node node, final String fileName) {
        try {
            NamedNodeMap attr = node.getAttributes();
            final String uri = attr.getNamedItem(URI).getNodeValue();
            AdapterInstaller installer = new AdapterInstaller(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void install(ReadGraph g, AdaptionService service) throws Exception {
                    Resource typeResource = g.getResource(uri);
                    service.declareAdapter(typeResource, interface_);
                    if (AdapterRegistry2.this.buildingCache) {
                        CachedAdapterDefinition def = CachedAdapterDefinition.forBaseType(typeResource.getResourceId(), interface_.getName(), b.getBundle() != null ? b.getBundle().getSymbolicName() : "unknown", fileName);
                        List<CachedAdapterDefinition> list = AdapterRegistry2.this.cacheDefinitions;
                        synchronized (list) {
                            AdapterRegistry2.this.cacheDefinitions.add(def);
                        }
                    }
                }
            };
            this.addInstaller(installer, fileName);
        }
        catch (Exception e) {
            AdapterRegistry2.handleException(e, fileName);
        }
    }

    public void updateAdaptionService(Session s, AdaptionService service, AdapterCacheManager cacheManager, boolean initializedFromCache) throws DatabaseException {
        s.syncRequest(g -> {
            Stream keys = this.installerSources.keySet().stream();
            if (initializedFromCache) {
                keys = (Stream)keys.parallel();
            }
            keys.forEach(t -> {
                try {
                    t.install(g, service);
                }
                catch (Throwable e) {
                    this.handleException(e, (AdapterInstaller)t);
                }
            });
            return null;
        });
        if (this.buildingCache && cacheManager != null && !this.cacheDefinitions.isEmpty()) {
            this.buildingCache = false;
            try {
                cacheManager.saveCache(this.cacheDefinitions);
            }
            catch (Exception e) {
                LOGGER.error("Failed to save adapter cache", (Throwable)e);
            }
        }
    }

    public void initializeFromCache(BundleContext context, AdapterCacheManager cacheManager) throws Exception {
        LOGGER.info("Initializing from cache");
        Map<String, Bundle> bundleMap = this.getBundleMap(context);
        LOGGER.info("Initialized bundle map");
        List<CachedAdapterDefinition> definitions = cacheManager.loadCache();
        LOGGER.info("Loaded cache file");
        for (CachedAdapterDefinition def : definitions) {
            try {
                AdapterInstaller installer = this.createInstallerFromCache(def, bundleMap);
                if (installer == null) continue;
                this.addInstaller(installer, def.sourceFile);
            }
            catch (Exception e) {
                LOGGER.error("Failed to create installer from cached definition: {}", (Object)def, (Object)e);
            }
        }
        LOGGER.info("Initialized {} adapters from cache", (Object)this.installerSources.size());
    }

    private AdapterInstaller createInstallerFromCache(CachedAdapterDefinition def, Map<String, Bundle> bundleMap) throws Exception {
        Bundle bundle = bundleMap.get(def.bundleSymbolicName);
        if (bundle == null) {
            LOGGER.warn("Bundle not found for cached adapter: {}", (Object)def.bundleSymbolicName);
            return null;
        }
        Loader loader = this.loader(bundle);
        switch (def.type) {
            case BASE_TYPE: {
                return this.createBaseTypeInstallerFromCache(def, loader);
            }
            case TYPE: {
                return this.createTypeInstallerFromCache(def, loader);
            }
            case RESOURCE: {
                return this.createResourceInstallerFromCache(def, loader);
            }
            case ADAPTER_CLASS: {
                return this.createAdapterClassInstallerFromCache(def, loader);
            }
            case INSTALLER: {
                return this.createCustomInstallerFromCache(def, loader);
            }
        }
        throw new IllegalArgumentException("Unknown adapter type: " + String.valueOf((Object)def.type));
    }

    private Map<String, Bundle> getBundleMap(BundleContext context) {
        HashMap<String, Bundle> result = new HashMap<String, Bundle>();
        Bundle[] bundleArray = context.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            result.put(bundle.getSymbolicName(), bundle);
            ++n2;
        }
        return result;
    }

    private static Resource getResourceById(ReadGraph g, long id) throws DatabaseException {
        return ((SerialisationSupport)g.getService(SerialisationSupport.class)).getResource(id);
    }

    private AdapterInstaller createBaseTypeInstallerFromCache(final CachedAdapterDefinition def, Loader loader) throws Exception {
        final Class<?> targetInterface = loader.loadClass(def.targetInterface);
        return new AdapterInstaller(){

            public void install(ReadGraph g, AdaptionService service) throws Exception {
                Resource typeResource = AdapterRegistry2.getResourceById(g, def.typeResourceId);
                service.declareAdapter(typeResource, targetInterface);
            }
        };
    }

    private <T> AdapterInstaller createTypeInstallerFromCache(final CachedAdapterDefinition def, final Loader loader) throws Exception {
        final Class<?> targetInterface = loader.loadClass(def.targetInterface);
        return new AdapterInstaller(){

            public void install(ReadGraph g, AdaptionService service) throws Exception {
                Class adapterClass = loader.loadClass(def.adapterClass).asSubclass(targetInterface);
                IDynamicAdapter2[] parameters = AdapterRegistry2.this.createParametersFromCache(g, def.parameters, loader);
                Resource typeResource = AdapterRegistry2.getResourceById(g, def.typeResourceId);
                if (def.constructor == null) {
                    service.addAdapter(typeResource, targetInterface, new ReflectionAdapter2(adapterClass, parameters));
                } else {
                    service.addAdapter(typeResource, targetInterface, new StaticMethodAdapter(adapterClass, def.constructor, parameters));
                }
            }
        };
    }

    private <T> AdapterInstaller createResourceInstallerFromCache(final CachedAdapterDefinition def, final Loader loader) throws Exception {
        final Class<?> targetInterface = loader.loadClass(def.targetInterface);
        return new AdapterInstaller(){

            public void install(ReadGraph g, AdaptionService service) throws Exception {
                Class adapterClass = loader.loadClass(def.adapterClass).asSubclass(targetInterface);
                IDynamicAdapter2[] parameters = AdapterRegistry2.this.createParametersFromCache(g, def.parameters, loader);
                Resource resource = AdapterRegistry2.getResourceById(g, def.typeResourceId);
                if (def.constructor == null) {
                    service.addInstanceAdapter(resource, targetInterface, new ReflectionAdapter2(adapterClass, parameters));
                } else {
                    service.addInstanceAdapter(resource, targetInterface, new StaticMethodAdapter(adapterClass, def.constructor, parameters));
                }
            }
        };
    }

    private <T> AdapterInstaller createAdapterClassInstallerFromCache(final CachedAdapterDefinition def, final Loader loader) throws Exception {
        final Class<?> targetInterface = loader.loadClass(def.targetInterface);
        final Class<Resource> contextClass = def.contextClass != null ? loader.loadClass(def.contextClass) : Resource.class;
        return new AdapterInstaller(){

            public void install(ReadGraph g, AdaptionService service) throws Exception {
                Class<?> adapterClass = loader.loadClass(def.adapterClass);
                Adapter adapter = adapterClass.asSubclass(Adapter.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Resource typeResource = AdapterRegistry2.getResourceById(g, def.typeResourceId);
                service.addAdapter(typeResource, targetInterface, contextClass, adapter);
            }
        };
    }

    private AdapterInstaller createCustomInstallerFromCache(CachedAdapterDefinition def, Loader loader) throws Exception {
        return loader.loadClass(def.installerClassName).asSubclass(AdapterInstaller.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private IDynamicAdapter2[] createParametersFromCache(ReadGraph g, List<CachedParameterDefinition> paramDefs, Loader loader) throws Exception {
        if (paramDefs == null || paramDefs.isEmpty()) {
            return new IDynamicAdapter2[0];
        }
        IDynamicAdapter2[] parameters = new IDynamicAdapter2[paramDefs.size()];
        SerialisationSupport ss = (SerialisationSupport)g.getService(SerialisationSupport.class);
        int i = 0;
        while (i < paramDefs.size()) {
            CachedParameterDefinition paramDef = paramDefs.get(i);
            IDynamicAdapter2 param = null;
            switch (paramDef.type) {
                case THIS: {
                    param = ThisResource2.INSTANCE;
                    break;
                }
                case GRAPH: {
                    param = GraphObject2.INSTANCE;
                    break;
                }
                case BUNDLE: {
                    if (paramDef.bundleId == null) {
                        param = new ConstantAdapter(Bundle.class, loader.getBundle());
                        break;
                    }
                    Bundle bundle = Platform.getBundle((String)paramDef.bundleId);
                    if (bundle != null) {
                        param = new ConstantAdapter(Bundle.class, bundle);
                        break;
                    }
                    throw new Exception("Bundle not found: " + paramDef.bundleId);
                }
                case RELATED: {
                    param = new RelatedResources2(ss.getResource(paramDef.relationResourceId));
                    break;
                }
                case ORDERED_SET: {
                    param = new OrderedSetResources2(ss.getResource(paramDef.relationResourceId));
                    break;
                }
                case SINGLE: {
                    param = new SingleRelatedResource2(ss.getResource(paramDef.relationResourceId));
                    break;
                }
                case AT_MOST_ONE: {
                    param = new AtMostOneRelatedResource2(ss.getResource(paramDef.relationResourceId));
                    break;
                }
                case STRING: {
                    param = new ConstantAdapter(String.class, paramDef.constantValue);
                }
            }
            if (param != null && paramDef.adaptTo != null) {
                param = new AdaptingDynamicAdapter2(param, loader.loadClass(paramDef.adaptTo));
            }
            parameters[i] = param;
            ++i;
        }
        return parameters;
    }

    public void initialize(ClassLoader b, String schemaURL, File[] files) {
        block6: {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                if (schemaURL != null && this.validateAgainstSchema()) {
                    factory.setValidating(true);
                    factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                    factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", schemaURL);
                }
                if (!this.exceptions.isEmpty()) break block6;
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    final File f = fileArray[n2];
                    try {
                        DocumentBuilder builder = factory.newDocumentBuilder();
                        builder.setErrorHandler(new ErrorHandler(){

                            @Override
                            public void error(SAXParseException exception) throws SAXException {
                                System.err.println("Parse error at " + f.getAbsolutePath() + " line " + exception.getLineNumber() + " column " + exception.getColumnNumber() + ":");
                                System.err.println(exception.getMessage());
                            }

                            @Override
                            public void fatalError(SAXParseException exception) throws SAXException {
                                this.error(exception);
                            }

                            @Override
                            public void warning(SAXParseException exception) throws SAXException {
                                this.error(exception);
                            }
                        });
                        Document doc = builder.parse(f);
                        this.handleAdaptersDocument(this.loader(b), doc, f.getAbsolutePath());
                    }
                    catch (Exception e) {
                        AdapterRegistry2.handleException(e, f.getAbsolutePath());
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                AdapterRegistry2.handleException(e, "(no file name available)");
            }
        }
    }

    private boolean validateAgainstSchema() {
        return Platform.inDevelopmentMode();
    }

    public void initialize(BundleContext context, AdapterCacheManager cacheManager) {
        LOGGER.info("Initializing from XML");
        this.buildingCache = cacheManager != null;
        this.cacheDefinitions.clear();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            if (this.validateAgainstSchema()) {
                factory.setValidating(true);
                factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", context.getBundle().getResource("adapters.xsd").toString());
            }
            ArrayList waitFor = new ArrayList();
            if (this.exceptions.isEmpty()) {
                Bundle[] bundleArray = context.getBundles();
                int n = bundleArray.length;
                int n2 = 0;
                while (n2 < n) {
                    final Bundle b = bundleArray[n2];
                    Future<?> submit = ThreadUtils.getNonBlockingWorkExecutor().submit(() -> {
                        URL file = b.getEntry(ADAPTERS_FILE);
                        if (file != null) {
                            String fileName = new Path(b.getLocation()).append(file.getPath()).toString();
                            try {
                                DocumentBuilder builder = factory.newDocumentBuilder();
                                builder.setErrorHandler(new ErrorHandler(){

                                    @Override
                                    public void error(SAXParseException exception) throws SAXException {
                                        System.err.println("Parse error at " + b.getSymbolicName() + "/adapters.xml line " + exception.getLineNumber() + " column " + exception.getColumnNumber() + ":");
                                        System.err.println(exception.getMessage());
                                    }

                                    @Override
                                    public void fatalError(SAXParseException exception) throws SAXException {
                                        this.error(exception);
                                    }

                                    @Override
                                    public void warning(SAXParseException exception) throws SAXException {
                                        this.error(exception);
                                    }
                                });
                                String text = FileUtils.getContents((URL)file);
                                text = OntologyVersions.getInstance().currentVersion(text);
                                StringReader reader = new StringReader(text);
                                InputSource inputSource = new InputSource(reader);
                                Document doc = builder.parse(inputSource);
                                reader.close();
                                this.handleAdaptersDocument(this.loader(b), doc, fileName);
                            }
                            catch (Exception e) {
                                AdapterRegistry2.handleException(e, fileName);
                            }
                        }
                    });
                    waitFor.add(submit);
                    ++n2;
                }
            }
            waitFor.forEach(f -> {
                try {
                    f.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    LOGGER.error("Could not wait adapters to load", (Throwable)e);
                }
            });
            LOGGER.info("Adapters installed");
        }
        catch (Exception e) {
            AdapterRegistry2.handleException(e, "(no file name available)");
        }
    }

    public void initialize(BundleContext context) {
        this.initialize(context, null);
    }

    private Loader loader(final Bundle b) {
        return new Loader(){

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                return b.loadClass(name);
            }

            @Override
            public Bundle getBundle() {
                return b;
            }
        };
    }

    private Loader loader(final ClassLoader b) {
        return new Loader(){

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                return b.loadClass(name);
            }

            @Override
            public Bundle getBundle() {
                return null;
            }
        };
    }

    static interface Loader {
        public Class<?> loadClass(String var1) throws ClassNotFoundException;

        public Bundle getBundle();
    }
}

