/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.services.adaption;

import java.io.BufferedOutputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.simantics.db.services.adaption.AdapterType;
import org.simantics.db.services.adaption.CacheInvalidException;
import org.simantics.db.services.adaption.CachedAdapterDefinition;
import org.simantics.db.services.adaption.CachedParameterDefinition;
import org.simantics.db.services.adaption.ParameterType;
import org.simantics.db.services.internal.Activator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdapterCacheManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdapterCacheManager.class);
    private static final String CACHE_FILE_NAME = "adapter-cache.bin";
    private static final String TIMESTAMPS_FILE_NAME = "adapter-timestamps.properties";
    private static final String ONTOLOGY_MARKER_FILE_NAME = "ontology-version.txt";
    private static final int CACHE_FORMAT_VERSION = 2;
    private final BundleContext context;
    private final Path cacheDir;

    public AdapterCacheManager(BundleContext context) {
        this.context = context;
        this.cacheDir = AdapterCacheManager.getCacheDirectory();
        try {
            Files.createDirectories(this.cacheDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("Failed to create cache directory", (Throwable)e);
        }
    }

    private static Path getCacheDirectory() {
        try {
            Path stateLocation = Platform.getStateLocation((Bundle)Activator.getDefault().getBundle()).toFile().toPath();
            return stateLocation.resolve("adapter-cache");
        }
        catch (Exception e) {
            LOGGER.warn("Could not get platform state location, using temp directory", (Throwable)e);
            return Paths.get(System.getProperty("java.io.tmpdir"), "simantics-adapter-cache");
        }
    }

    private Path getCacheFile() {
        return this.cacheDir.resolve(CACHE_FILE_NAME);
    }

    private Path getTimestampsFile() {
        return this.cacheDir.resolve(TIMESTAMPS_FILE_NAME);
    }

    private Path getOntologyMarkerFile() {
        return this.cacheDir.resolve(ONTOLOGY_MARKER_FILE_NAME);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isCacheValid() {
        if ("false".equals(System.getProperty("simantics.adapters.cache.enabled"))) {
            LOGGER.info("Adapter cache disabled via system property");
            return false;
        }
        Path cacheFile = this.getCacheFile();
        Path timestampsFile = this.getTimestampsFile();
        if (!Files.exists(cacheFile, new LinkOption[0])) {
            LOGGER.debug("Cache file does not exist");
            return false;
        }
        if (!Files.exists(timestampsFile, new LinkOption[0])) {
            LOGGER.debug("Timestamps file does not exist");
            return false;
        }
        try {
            Path ontologyMarkerFile = this.getOntologyMarkerFile();
            if (Files.exists(ontologyMarkerFile, new LinkOption[0]) && Files.getLastModifiedTime(ontologyMarkerFile, new LinkOption[0]).toMillis() > Files.getLastModifiedTime(cacheFile, new LinkOption[0]).toMillis()) {
                LOGGER.info("Cache invalid: ontology changes detected");
                return false;
            }
        }
        catch (IOException e) {
            LOGGER.warn("Failed to check ontology marker file", (Throwable)e);
            return false;
        }
        try {
            String bundleId;
            FileChecksum cached;
            FileChecksum current;
            Map<String, FileChecksum> currentChecksums = this.computeAdapterFileChecksums();
            Map<String, FileChecksum> cachedChecksums = this.loadTimestamps();
            if (currentChecksums.size() != cachedChecksums.size()) {
                LOGGER.info("Cache invalid: number of bundles with adapters.xml changed ({} -> {})", (Object)cachedChecksums.size(), (Object)currentChecksums.size());
                return false;
            }
            Iterator<Map.Entry<String, FileChecksum>> iterator = currentChecksums.entrySet().iterator();
            do {
                if (!iterator.hasNext()) {
                    LOGGER.info("Cache is valid");
                    return true;
                }
                Map.Entry<String, FileChecksum> entry = iterator.next();
                bundleId = entry.getKey();
                current = entry.getValue();
                cached = cachedChecksums.get(bundleId);
                if (cached == null) {
                    LOGGER.info("Cache invalid: new bundle with adapters.xml: {}", (Object)bundleId);
                    return false;
                }
                if (current.lastModified <= cached.lastModified) continue;
                LOGGER.info("Cache invalid: adapters.xml modified in bundle: {}", (Object)bundleId);
                return false;
            } while (current.md5.equals(cached.md5));
            LOGGER.info("Cache invalid: adapters.xml checksum changed in bundle: {}", (Object)bundleId);
            return false;
        }
        catch (Exception e) {
            LOGGER.warn("Error validating cache", (Throwable)e);
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    public List<CachedAdapterDefinition> loadCache() throws CacheInvalidException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveCache(List<CachedAdapterDefinition> definitions) {
        Path cacheFile = this.getCacheFile();
        try {
            block21: {
                Files.createDirectories(this.cacheDir, new FileAttribute[0]);
                CacheData data = new CacheData(2, System.currentTimeMillis(), definitions);
                Throwable throwable = null;
                Object var5_7 = null;
                try {
                    OutputStream os = Files.newOutputStream(cacheFile, new OpenOption[0]);
                    try {
                        block20: {
                            BufferedOutputStream bos = new BufferedOutputStream(os, 131072);
                            try {
                                try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
                                    data.writeExternal(oos);
                                }
                                if (bos == null) break block20;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                if (bos == null) throw throwable;
                                bos.close();
                                throw throwable;
                            }
                            bos.close();
                        }
                        if (os == null) break block21;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (os == null) throw throwable;
                        os.close();
                        throw throwable;
                    }
                    os.close();
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                        throw throwable;
                    }
                    if (throwable == throwable4) throw throwable;
                    throwable.addSuppressed(throwable4);
                    throw throwable;
                }
            }
            Map<String, FileChecksum> checksums = this.computeAdapterFileChecksums();
            this.saveTimestamps(checksums);
            LOGGER.info("Saved {} adapter definitions to cache", (Object)definitions.size());
            return;
        }
        catch (IOException e) {
            LOGGER.error("Failed to save cache", (Throwable)e);
        }
    }

    public void invalidateCache() {
        Path cacheFile = this.getCacheFile();
        Path timestampsFile = this.getTimestampsFile();
        try {
            if (Files.deleteIfExists(cacheFile)) {
                LOGGER.info("Deleted cache file");
            }
            if (Files.deleteIfExists(timestampsFile)) {
                LOGGER.info("Deleted timestamps file");
            }
        }
        catch (IOException e) {
            LOGGER.warn("Failed to delete cache files", (Throwable)e);
        }
    }

    public static void markOntologyChange() {
        try {
            Path cacheDir = AdapterCacheManager.getCacheDirectory();
            Files.createDirectories(cacheDir, new FileAttribute[0]);
            Path markerFile = cacheDir.resolve(ONTOLOGY_MARKER_FILE_NAME);
            String marker = String.valueOf(System.currentTimeMillis());
            Files.write(markerFile, marker.getBytes(), new OpenOption[0]);
            LOGGER.info("Marked ontology change, adapter cache will be invalidated on next startup");
        }
        catch (Exception e) {
            LOGGER.warn("Failed to mark ontology change", (Throwable)e);
        }
    }

    private Map<String, FileChecksum> computeAdapterFileChecksums() {
        ConcurrentHashMap<String, FileChecksum> checksums = new ConcurrentHashMap<String, FileChecksum>();
        Map<String, FileChecksum> prevChecksums = this.loadTimestamps();
        BiConsumer<Bundle, Consumer> adapterResolver = (b, c) -> {
            URL entry = b.getEntry("adapters.xml");
            if (entry != null) {
                try {
                    URL fileUrl = FileLocator.toFileURL((URL)entry);
                    if (fileUrl.getProtocol().equals("file")) {
                        File f = new File(URLDecoder.decode(fileUrl.getPath(), "UTF-8")).getAbsoluteFile();
                        Path p = f.toPath();
                        FileTime lastModified = Files.getLastModifiedTime(p, new LinkOption[0]);
                        c.accept(new BundleURL((Bundle)b, fileUrl, p, lastModified.toMillis()));
                    }
                }
                catch (IOException e) {
                    LOGGER.warn("Cannot read last modification time for {}", (Object)entry, (Object)e);
                }
            }
        };
        Consumer<BundleURL> checksummer = b -> {
            String bundleId = b.bundle.getSymbolicName();
            try {
                long currentModTime = b.lastModified;
                FileChecksum prev = (FileChecksum)prevChecksums.get(bundleId);
                if (prev != null && prev.lastModified == currentModTime) {
                    checksums.put(bundleId, prev);
                } else {
                    String md5 = this.computeMD5(b.path);
                    checksums.put(bundleId, new FileChecksum(currentModTime, md5));
                }
            }
            catch (Exception e) {
                LOGGER.warn("Failed to compute checksum for " + bundleId, (Throwable)e);
            }
        };
        ((Stream)Arrays.stream(this.context.getBundles()).parallel()).mapMulti(adapterResolver).forEach(checksummer);
        return checksums;
    }

    private String computeMD5(Path p) throws IOException {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] bytes = Files.readAllBytes(p);
            byte[] digest = md.digest(bytes);
            StringBuilder sb = new StringBuilder();
            byte[] byArray = digest;
            int n = digest.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                sb.append(String.format("%02x", b));
                ++n2;
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("MD5 should be supported", e);
        }
    }

    private Map<String, FileChecksum> loadTimestamps() {
        HashMap<String, FileChecksum> checksums = new HashMap<String, FileChecksum>();
        Path timestampsFile = this.getTimestampsFile();
        if (!Files.exists(timestampsFile, new LinkOption[0])) {
            return checksums;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream is = Files.newInputStream(timestampsFile, new OpenOption[0]);){
                Properties props = new Properties();
                props.load(is);
                for (String key : props.stringPropertyNames()) {
                    if (!key.endsWith(".modtime")) continue;
                    String bundleId = key.substring(0, key.length() - ".modtime".length());
                    long modTime = Long.parseLong(props.getProperty(key));
                    String md5 = props.getProperty(bundleId + ".md5");
                    if (md5 == null) continue;
                    checksums.put(bundleId, new FileChecksum(modTime, md5));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to load timestamps", (Throwable)e);
        }
        return checksums;
    }

    private void saveTimestamps(Map<String, FileChecksum> checksums) throws IOException {
        Properties props = new Properties();
        for (Map.Entry<String, FileChecksum> entry : checksums.entrySet()) {
            String bundleId = entry.getKey();
            FileChecksum checksum = entry.getValue();
            props.setProperty(bundleId + ".modtime", String.valueOf(checksum.lastModified));
            props.setProperty(bundleId + ".md5", checksum.md5);
        }
        Path timestampsFile = this.getTimestampsFile();
        Object object = null;
        Object var5_6 = null;
        try (OutputStream os = Files.newOutputStream(timestampsFile, new OpenOption[0]);){
            props.store(os, "Adapter file checksums");
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
            } else if (object != throwable) {
                ((Throwable)object).addSuppressed(throwable);
            }
            throw object;
        }
    }

    private record BundleURL(Bundle bundle, URL file, Path path, long lastModified) {
    }

    private static class CacheData
    implements Externalizable {
        private static final long serialVersionUID = 2L;
        private int formatVersion;
        private long timestamp;
        private List<CachedAdapterDefinition> definitions;

        public CacheData() {
        }

        public CacheData(int formatVersion, long timestamp, List<CachedAdapterDefinition> definitions) {
            this.formatVersion = formatVersion;
            this.timestamp = timestamp;
            this.definitions = definitions;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.formatVersion);
            out.writeLong(this.timestamp);
            StringTable stringTable = new StringTable();
            for (CachedAdapterDefinition def : this.definitions) {
                stringTable.add(def.targetInterface);
                stringTable.add(def.adapterClass);
                stringTable.add(def.contextClass);
                stringTable.add(def.constructor);
                stringTable.add(def.installerClassName);
                stringTable.add(def.bundleSymbolicName);
                stringTable.add(def.sourceFile);
                if (def.parameters == null) continue;
                for (CachedParameterDefinition param : def.parameters) {
                    stringTable.add(param.constantValue);
                    stringTable.add(param.bundleId);
                    stringTable.add(param.adaptTo);
                }
            }
            stringTable.write(out);
            out.writeInt(this.definitions.size());
            for (CachedAdapterDefinition def : this.definitions) {
                this.writeDefinitionWithStringTable(out, def, stringTable);
            }
        }

        private void writeDefinitionWithStringTable(ObjectOutput out, CachedAdapterDefinition def, StringTable stringTable) throws IOException {
            out.writeByte(def.type.ordinal());
            out.writeLong(def.typeResourceId);
            out.writeInt(stringTable.getIndex(def.targetInterface));
            out.writeInt(stringTable.getIndex(def.adapterClass));
            out.writeInt(stringTable.getIndex(def.contextClass));
            out.writeInt(stringTable.getIndex(def.constructor));
            out.writeInt(stringTable.getIndex(def.installerClassName));
            out.writeInt(stringTable.getIndex(def.bundleSymbolicName));
            out.writeInt(stringTable.getIndex(def.sourceFile));
            int paramCount = def.parameters != null ? def.parameters.size() : 0;
            out.writeInt(paramCount);
            int i = 0;
            while (i < paramCount) {
                this.writeParameterWithStringTable(out, def.parameters.get(i), stringTable);
                ++i;
            }
        }

        private void writeParameterWithStringTable(ObjectOutput out, CachedParameterDefinition param, StringTable stringTable) throws IOException {
            out.writeByte(param.type.ordinal());
            out.writeLong(param.relationResourceId);
            out.writeInt(stringTable.getIndex(param.constantValue));
            out.writeInt(stringTable.getIndex(param.bundleId));
            out.writeInt(stringTable.getIndex(param.adaptTo));
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.formatVersion = in.readInt();
            this.timestamp = in.readLong();
            StringTable stringTable = new StringTable();
            stringTable.read(in);
            int defCount = in.readInt();
            ArrayList<CachedAdapterDefinition> defs = new ArrayList<CachedAdapterDefinition>(defCount);
            int i = 0;
            while (i < defCount) {
                defs.add(this.readDefinitionWithStringTable(in, stringTable));
                ++i;
            }
            this.definitions = defs;
        }

        private CachedAdapterDefinition readDefinitionWithStringTable(ObjectInput in, StringTable stringTable) throws IOException {
            CachedAdapterDefinition def = new CachedAdapterDefinition();
            def.type = AdapterType.values()[in.readByte()];
            def.typeResourceId = in.readLong();
            def.targetInterface = stringTable.getString(in.readInt());
            def.adapterClass = stringTable.getString(in.readInt());
            def.contextClass = stringTable.getString(in.readInt());
            def.constructor = stringTable.getString(in.readInt());
            def.installerClassName = stringTable.getString(in.readInt());
            def.bundleSymbolicName = stringTable.getString(in.readInt());
            def.sourceFile = stringTable.getString(in.readInt());
            int paramCount = in.readInt();
            def.parameters = new ArrayList<CachedParameterDefinition>(paramCount);
            int i = 0;
            while (i < paramCount) {
                def.parameters.add(this.readParameterWithStringTable(in, stringTable));
                ++i;
            }
            return def;
        }

        private CachedParameterDefinition readParameterWithStringTable(ObjectInput in, StringTable stringTable) throws IOException {
            CachedParameterDefinition param = new CachedParameterDefinition();
            param.type = ParameterType.values()[in.readByte()];
            param.relationResourceId = in.readLong();
            param.constantValue = stringTable.getString(in.readInt());
            param.bundleId = stringTable.getString(in.readInt());
            param.adaptTo = stringTable.getString(in.readInt());
            return param;
        }
    }

    private record FileChecksum(long lastModified, String md5) {
    }

    private static class StringTable {
        private final Map<String, Integer> stringToIndex = new HashMap<String, Integer>();
        private final List<String> indexToString = new ArrayList<String>();

        private StringTable() {
        }

        void add(String str) {
            if (str != null && !this.stringToIndex.containsKey(str)) {
                int index = this.indexToString.size();
                this.stringToIndex.put(str, index);
                this.indexToString.add(str);
            }
        }

        int getIndex(String str) {
            if (str == null) {
                return -1;
            }
            Integer index = this.stringToIndex.get(str);
            return index != null ? index : -1;
        }

        String getString(int index) {
            return index >= 0 ? this.indexToString.get(index) : null;
        }

        void write(ObjectOutput out) throws IOException {
            out.writeInt(this.indexToString.size());
            for (String str : this.indexToString) {
                out.writeUTF(str);
            }
        }

        void read(ObjectInput in) throws IOException {
            int size = in.readInt();
            this.indexToString.clear();
            this.stringToIndex.clear();
            int i = 0;
            while (i < size) {
                String str = in.readUTF();
                this.indexToString.add(str);
                this.stringToIndex.put(str, i);
                ++i;
            }
        }
    }
}

