/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.services;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;
import org.simantics.db.Session;
import org.simantics.db.adaption.AdaptionService;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.services.ServiceInitializer;
import org.simantics.db.services.adaption.AdapterCacheManager;
import org.simantics.db.services.adaption.AdapterRegistry2;
import org.simantics.db.services.adaption.AdaptionService2;
import org.simantics.db.services.internal.Activator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdaptionServiceInitializer
implements ServiceInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdaptionServiceInitializer.class);

    @Override
    public IStatus initialize(Session s) {
        LOGGER.info("Initializing AdaptionService");
        long startTime = System.currentTimeMillis();
        AdaptionService2 service = new AdaptionService2();
        s.registerService(AdaptionService.class, (Object)service);
        try {
            long elapsed;
            AdapterRegistry2 registry = new AdapterRegistry2();
            BundleContext context = Activator.getDefault().getContext();
            AdapterCacheManager cacheManager = new AdapterCacheManager(context);
            boolean usedCache = false;
            if (cacheManager.isCacheValid()) {
                try {
                    LOGGER.info("Loading adapters from cache");
                    registry.initializeFromCache(context, cacheManager);
                    elapsed = System.currentTimeMillis() - startTime;
                    LOGGER.info("Adapters loaded from cache in {} ms", (Object)elapsed);
                    usedCache = true;
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to load from cache, falling back to XML parsing", (Throwable)e);
                    usedCache = false;
                }
            }
            if (!usedCache) {
                LOGGER.info("Cache invalid or missing, rebuilding from XML");
                registry = new AdapterRegistry2();
                registry.initialize(context, cacheManager);
                elapsed = System.currentTimeMillis() - startTime;
                LOGGER.info("Adapters initialized from XML in {} ms", (Object)elapsed);
            }
            LOGGER.info("Updating AdaptionService");
            long updateStart = System.currentTimeMillis();
            registry.updateAdaptionService(s, service, cacheManager, usedCache);
            long updateElapsed = System.currentTimeMillis() - updateStart;
            LOGGER.info("AdaptionService updated in {} ms", (Object)updateElapsed);
            long totalElapsed = System.currentTimeMillis() - startTime;
            LOGGER.info("Total AdaptionService initialization time: {} ms", (Object)totalElapsed);
            return Status.OK_STATUS;
        }
        catch (DatabaseException e) {
            Status status = new Status(4, "org.simantics.db.services", "AdapterRegistry2 instantiation failed, see exception for details.", (Throwable)e);
            return status;
        }
    }
}

