/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.services.adaption.reflection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncProcedure;

public class StaticMethodAdapter<T> extends AbstractReflectionAdapter<T> {

	Method constructor;
	
	public StaticMethodAdapter(Class<? extends T> clazz, String methodName, IDynamicAdapter2 ... parameters) throws SecurityException, NoSuchMethodException, DatabaseException {
	    super(parameters);	    
		Class<?>[] parameterTypes = new Class<?>[parameters.length];
		for(int i=0;i<parameters.length;++i)
			parameterTypes[i] = parameters[i].getType();
		this.constructor = clazz.getMethod(methodName, parameterTypes);
	}
	
	@SuppressWarnings("unchecked")
    @Override
	public void construct(AsyncReadGraph g, AsyncProcedure<T> procedure, Object ... args) {
	    try {
            procedure.execute(g, (T)constructor.invoke(null, args));
        } catch (IllegalArgumentException e) {
            procedure.exception(g, e);
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            procedure.exception(g, e);
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            procedure.exception(g, e.getCause());
            e.getCause().printStackTrace();
        }
	}
	    
    @Override
    public String toString() {
        return "ReflectionAdapter for " + constructor.getName();
    }

}
