/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.services.adaption.reflection;

import java.util.Collection;

import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;

public class RelatedResources2 implements IDynamicAdapter2 {

	Resource relation;
	
	public RelatedResources2(Resource relation) {
		this.relation = relation;
	}

	@Override
	public Class<?> getType() {
		return Collection.class;
	}

	@Override
	public Collection<Resource> adapt(ReadGraph g, Resource r) throws DatabaseException {
		return g.getObjects(r, relation);
	}

}
