/*******************************************************************************
 * Copyright (c) 2026 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.db.services.adaption;

/**
 * Enumeration of parameter types for adapter constructors in the cache.
 * 
 * @author Tuukka Lehtonen
 * @since 1.67.0
 */
public enum ParameterType {
    /**
     * The resource being adapted (corresponds to &lt;this/&gt;)
     */
    THIS,
    
    /**
     * The ReadGraph instance (corresponds to &lt;graph/&gt;)
     */
    GRAPH,
    
    /**
     * An OSGi Bundle reference (corresponds to &lt;bundle/&gt;)
     */
    BUNDLE,
    
    /**
     * Related resources via a relation (corresponds to &lt;related uri="..."/&gt;)
     */
    RELATED,
    
    /**
     * Ordered set of related resources (corresponds to &lt;orderedSet uri="..."/&gt;)
     */
    ORDERED_SET,
    
    /**
     * Single related resource (corresponds to &lt;single uri="..."/&gt;)
     */
    SINGLE,
    
    /**
     * At most one related resource (corresponds to &lt;atMostOne uri="..."/&gt;)
     */
    AT_MOST_ONE,
    
    /**
     * String constant (corresponds to &lt;string&gt;...&lt;/string&gt;)
     */
    STRING
}
