/*******************************************************************************
 * Copyright (c) 2026 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.db.services.adaption;

/**
 * Exception thrown when the adapter cache is invalid or cannot be used.
 * This exception signals that initialization should fall back to XML parsing.
 * 
 * @author Tuukka Lehtonen
 * @since 1.67.0
 */
public class CacheInvalidException extends Exception {
    
    private static final long serialVersionUID = 1L;
    
    public CacheInvalidException(String message) {
        super(message);
    }
    
    public CacheInvalidException(String message, Throwable cause) {
        super(message, cause);
    }
}
