/*******************************************************************************
 * Copyright (c) 2026 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.db.services.adaption;

/**
 * Enumeration of adapter definition types in the adapter registry cache.
 * 
 * @author Tuukka Lehtonen
 * @since 1.67.0
 */
public enum AdapterType {
    /**
     * Adapter for a type (uses &lt;type&gt; element in adapters.xml)
     */
    TYPE,
    
    /**
     * Adapter for a specific resource instance (uses &lt;resource&gt; element in adapters.xml)
     */
    RESOURCE,
    
    /**
     * Base type declaration (uses &lt;baseType&gt; element in adapters.xml)
     */
    BASE_TYPE,
    
    /**
     * Adapter class reference (uses &lt;adapter&gt; element in adapters.xml)
     */
    ADAPTER_CLASS,
    
    /**
     * Custom installer class (uses &lt;installer&gt; element in adapters.xml)
     */
    INSTALLER
}
