/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.variable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.DatatypeConstructionException;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.variable.StandardGraphPropertyVariable;
import org.simantics.db.layer0.variable.ValueAccessor;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableMap;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.layer0.Layer0;

public class StandardConstantGraphPropertyVariable
extends StandardGraphPropertyVariable {
    public final Object value;
    private transient int hash = 0;

    public StandardConstantGraphPropertyVariable(ReadGraph graph, Variable parent, Resource property, Object value) throws DatabaseException {
        super(graph, parent, null, property);
        assert (parent != null);
        assert (property != null);
        assert (value != null);
        this.value = value;
    }

    @Override
    public void validate(ReadGraph graph) throws DatabaseException {
    }

    @Override
    public String getName(ReadGraph graph) throws DatabaseException {
        return (String)graph.getRelatedValue(this.property.predicate, ((Layer0)graph.getService(Layer0.class)).HasName, (Binding)Bindings.STRING);
    }

    @Override
    public String getLabel(ReadGraph graph) throws DatabaseException {
        return (String)graph.getRelatedValue2(this.property.predicate, ((Layer0)graph.getService(Layer0.class)).HasLabel, (Object)this.parent);
    }

    @Override
    public Variable getParent(ReadGraph graph) throws DatabaseException {
        return this.parent;
    }

    @Override
    public <T> T getValue(ReadGraph graph) throws DatabaseException {
        this.assertAlive(graph);
        return (T)this.getValueAccessor(graph).getValue(graph, this);
    }

    @Override
    public <T> T getValue(ReadGraph graph, Binding binding) throws DatabaseException {
        this.assertAlive(graph);
        return (T)this.getValueAccessor(graph).getValue(graph, this, binding);
    }

    @Override
    public Resource getRepresents(ReadGraph graph) throws DatabaseException {
        this.assertAlive(graph);
        return null;
    }

    @Override
    public Resource getPossibleRepresents(ReadGraph graph) throws DatabaseException {
        this.assertAlive(graph);
        return null;
    }

    @Override
    public void setValue(WriteGraph graph, Object value, Binding binding) throws DatabaseException {
        this.assertAlive((ReadGraph)graph);
        this.getValueAccessor((ReadGraph)graph).setValue(graph, this, value, binding);
    }

    @Override
    public void setValue(WriteGraph graph, Object value) throws DatabaseException {
        this.assertAlive((ReadGraph)graph);
        this.getValueAccessor((ReadGraph)graph).setValue(graph, this, value);
    }

    @Override
    public Datatype getDatatype(ReadGraph graph) throws DatabaseException {
        try {
            return Layer0Utils.getDatatype(graph, this);
        }
        catch (DatabaseException databaseException) {
            return null;
        }
    }

    @Override
    public String getUnit(ReadGraph graph) throws DatabaseException {
        try {
            return Layer0Utils.getUnit(graph, this);
        }
        catch (DatabaseException databaseException) {
            return null;
        }
    }

    @Override
    public Resource getContainerResource(ReadGraph graph) throws DatabaseException {
        return null;
    }

    @Override
    public Collection<Variable> getChildren(ReadGraph graph) throws DatabaseException {
        HashMap<String, Variable> result = new HashMap<String, Variable>();
        VariableMap map = this.getPossibleChildVariableMap(graph);
        if (map != null) {
            map.getVariables(graph, this, result);
        }
        return result.values();
    }

    @Override
    public Variable getPossibleChild(ReadGraph graph, String name) throws DatabaseException {
        VariableMap map = this.getPossibleChildVariableMap(graph);
        if (map == null) {
            return null;
        }
        try {
            return map.getVariable(graph, this, name);
        }
        catch (DatabaseException databaseException) {
            return null;
        }
    }

    @Override
    protected Variable getPossibleDomainProperty(ReadGraph graph, String name) throws DatabaseException {
        VariableMap valueMap = this.getPossiblePropertyVariableMap(graph);
        if (valueMap == null) {
            return null;
        }
        try {
            return valueMap.getVariable(graph, this, name);
        }
        catch (DatabaseException databaseException) {
            return null;
        }
    }

    @Override
    public Map<String, Variable> collectDomainProperties(ReadGraph graph, Map<String, Variable> properties) throws DatabaseException {
        VariableMap valueMap = this.getPossiblePropertyVariableMap(graph);
        if (valueMap == null) {
            return properties;
        }
        return valueMap.getVariables(graph, this, properties);
    }

    @Override
    public Variable getPredicate(ReadGraph graph) throws DatabaseException {
        return Variables.getVariable(graph, graph.getURI(this.property.predicate));
    }

    @Override
    public Resource getPredicateResource(ReadGraph graph) throws DatabaseException {
        return this.property.predicate;
    }

    @Override
    public Resource getPossiblePredicateResource(ReadGraph graph) throws DatabaseException {
        return this.property.predicate;
    }

    @Override
    public int hashCode() {
        if (this.hash == 0) {
            int result = 1;
            result = 31 * result + this.parent.hashCode();
            result = 31 * result + this.property.hashCode();
            this.hash = result = 31 * result + this.value.hashCode();
        }
        return this.hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StandardConstantGraphPropertyVariable other = (StandardConstantGraphPropertyVariable)obj;
        if (!this.value.equals(other.value)) {
            return false;
        }
        return super.equals(other);
    }

    @Override
    protected Variable getNameVariable(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        return new StandardGraphPropertyVariable(graph, this, L0.HasName);
    }

    private void assertAlive(ReadGraph graph) throws DatabaseException {
    }

    @Override
    protected ValueAccessor getValueAccessor(ReadGraph graph) throws DatabaseException {
        return new ValueAccessor(){

            @Override
            public void setValue(WriteGraph graph, Variable context, Object value, Binding binding) throws DatabaseException {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setValue(WriteGraph graph, Variable context, Object value) throws DatabaseException {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object getValue(ReadGraph graph, Variable context, Binding binding) throws DatabaseException {
                return StandardConstantGraphPropertyVariable.this.value;
            }

            @Override
            public Object getValue(ReadGraph graph, Variable context) throws DatabaseException {
                return StandardConstantGraphPropertyVariable.this.value;
            }

            @Override
            public Datatype getDatatype(ReadGraph graph, Variable context) throws DatabaseException {
                try {
                    return Datatypes.getDatatype(StandardConstantGraphPropertyVariable.this.value.getClass());
                }
                catch (DatatypeConstructionException e) {
                    throw new DatabaseException((Throwable)e);
                }
            }
        };
    }

    @Override
    protected VariableMap getPossibleChildVariableMap(ReadGraph graph) throws DatabaseException {
        return (VariableMap)graph.getPossibleRelatedValue2(this.property.predicate, Layer0.getInstance((ReadGraph)graph).domainChildren, (Object)this);
    }

    @Override
    protected VariableMap getPossiblePropertyVariableMap(ReadGraph graph) throws DatabaseException {
        return (VariableMap)graph.getPossibleRelatedValue2(this.property.predicate, Layer0.getInstance((ReadGraph)graph).domainProperties, (Object)this);
    }

    @Override
    public Set<String> getClassifications(ReadGraph graph) throws DatabaseException {
        ArrayList value = (ArrayList)this.getPropertyValue(graph, "classifications");
        return new HashSet<String>(value);
    }
}

