/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.validation;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.simantics.db.ChangeSet;
import org.simantics.db.Issue;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.Functions;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.event.ChangeEvent;
import org.simantics.db.event.ChangeListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.validation.GetConstraints;
import org.simantics.db.request.ReadInterface;
import org.simantics.layer0.Layer0;

public class ChangeSetValidator
implements ChangeListener {
    void reportInconsistency(ReadGraph graph, Resource subject, String description) throws DatabaseException {
        System.err.println("Change set validation reports the following issue: " + NameUtils.getSafeName((ReadGraph)graph, (Resource)subject, (boolean)true) + ": " + description);
    }

    public void graphChanged(ChangeEvent e) throws DatabaseException {
        ChangeSet changeSet = e.getChanges();
        ReadGraph g = e.getGraph();
        HashSet<Resource> allResources = new HashSet<Resource>();
        for (ChangeSet.StatementChange change : changeSet.changedStatements()) {
            allResources.add(change.getSubject());
            allResources.add(change.getObject());
        }
        for (Resource resource : changeSet.changedValues()) {
            allResources.add(resource);
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        for (Resource r : allResources) {
            try {
                for (Resource constraint : (Set)g.sync((ReadInterface)new GetConstraints(r))) {
                    try {
                        Resource function = g.getSingleObject(constraint, L0.Constraint_Validator);
                        HashSet contexts = new HashSet((List)Functions.exec((RequestProcessor)g, (Resource)function, (Object[])new Object[]{g, r}));
                        for (Issue i : contexts) {
                            this.reportInconsistency(g, r, g.getURI(i.getType()));
                        }
                    }
                    catch (Throwable t) {
                        Logger.defaultLogError((Throwable)t);
                    }
                }
            }
            catch (Throwable t) {
                Logger.defaultLogError((Throwable)t);
            }
        }
    }

    private boolean isInstanceOfAny(ReadGraph graph, Resource r, Collection<Resource> types, boolean ifEmpty) throws DatabaseException {
        if (types.isEmpty()) {
            return ifEmpty;
        }
        for (Resource type : types) {
            if (!graph.isInstanceOf(r, type)) continue;
            return true;
        }
        return false;
    }

    private StringBuilder orString(ReadGraph graph, StringBuilder sb, Collection<Resource> rs) throws DatabaseException {
        sb.append("(");
        boolean first = true;
        for (Resource r : rs) {
            if (!first) {
                sb.append(" | ");
            }
            first = false;
            sb.append(NameUtils.getSafeName((ReadGraph)graph, (Resource)r));
        }
        sb.append(")");
        return sb;
    }

    public static boolean isRelation(ReadGraph g, Layer0 l0, Resource relation) throws DatabaseException {
        return g.hasStatement(relation, l0.SubrelationOf) || relation == l0.IsWeaklyRelatedTo;
    }

    public static boolean isType(ReadGraph g, Layer0 l0, Resource type) throws DatabaseException {
        return g.hasStatement(type, l0.Inherits) || type == l0.Entity;
    }
}

