/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.ParametrizedPrimitiveRead;
import org.simantics.db.common.utils.CommonDBUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.internal.SimanticsInternal;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.ExternalRead;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.scl.compiler.environment.specification.EnvironmentSpecification;
import org.simantics.scl.compiler.module.repository.ImportFailureException;
import org.simantics.scl.compiler.module.repository.UpdateListener;
import org.simantics.scl.compiler.runtime.RuntimeEnvironment;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.runtime.SCLContext;

public class RuntimeEnvironmentRequest2
extends BinaryRead<Resource, Resource, RuntimeEnvironment> {
    public RuntimeEnvironmentRequest2(Resource componentType, Resource indexRoot) {
        super((Object)componentType, (Object)indexRoot);
    }

    protected void fillEnvironmentSpecification(EnvironmentSpecification environmentSpecification) {
    }

    public static void getRuntimeEnvironment(final EnvironmentSpecification environmentSpecification, final Listener<RuntimeEnvironment> callback, final UpdateListenerImpl listener) {
        try {
            RuntimeEnvironment env;
            SCLContext context = SCLContext.getCurrent();
            Object graph = context.get((Object)"graph");
            if (graph == null) {
                try {
                    env = (RuntimeEnvironment)SimanticsInternal.getSession().syncRequest((Read)new Read<RuntimeEnvironment>(){

                        public RuntimeEnvironment perform(ReadGraph graph) throws DatabaseException {
                            SCLContext sclContext = SCLContext.getCurrent();
                            Object oldGraph = sclContext.get((Object)"graph");
                            try {
                                sclContext.put((Object)"graph", (Object)graph);
                                RuntimeEnvironment runtimeEnvironment = SCLOsgi.MODULE_REPOSITORY.createRuntimeEnvironment(environmentSpecification, callback.getClass().getClassLoader(), (UpdateListener)listener);
                                return runtimeEnvironment;
                            }
                            catch (ImportFailureException e) {
                                throw new DatabaseException((Throwable)e);
                            }
                            catch (Throwable t) {
                                throw new DatabaseException(t);
                            }
                            finally {
                                sclContext.put((Object)"graph", oldGraph);
                            }
                        }
                    });
                }
                catch (DatabaseException e) {
                    callback.exception((Throwable)e);
                    return;
                }
            } else {
                env = SCLOsgi.MODULE_REPOSITORY.createRuntimeEnvironment(environmentSpecification, callback.getClass().getClassLoader(), (UpdateListener)listener);
            }
            callback.execute((Object)env);
        }
        catch (ImportFailureException e) {
            callback.exception((Throwable)new DatabaseException((Throwable)e));
        }
    }

    public RuntimeEnvironment perform(ReadGraph graph) throws DatabaseException {
        Resource mainModule;
        EnvironmentSpecification environmentSpecification = EnvironmentSpecification.of((String[])new String[]{"Builtin", "", "StandardLibrary", "", "Simantics/All", ""});
        this.fillEnvironmentSpecification(environmentSpecification);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        if (this.parameter != null) {
            Collection sclModules = (Collection)graph.syncRequest((Read)new ObjectsWithType((Resource)this.parameter, L0.ConsistsOf, L0.SCLModule));
            for (Resource sclModule : sclModules) {
                environmentSpecification.importModule(graph.getURI(sclModule), "");
            }
        }
        if ((mainModule = CommonDBUtils.getPossibleChild((ReadGraph)graph, (Resource)((Resource)this.parameter2), (String)"SCLMain")) != null) {
            environmentSpecification.importModule(graph.getURI(mainModule), "");
            for (Resource l : graph.getObjects((Resource)this.parameter2, L0.IsLinkedTo)) {
                mainModule = CommonDBUtils.getPossibleChild((ReadGraph)graph, (Resource)l, (String)"SCLMain");
                if (mainModule == null) continue;
                environmentSpecification.importModule(graph.getURI(mainModule), "");
            }
        }
        return (RuntimeEnvironment)graph.syncRequest((ExternalRead)new ParametrizedPrimitiveRead<EnvironmentSpecification, RuntimeEnvironment>(environmentSpecification){
            UpdateListenerImpl sclListener;

            public void register(ReadGraph graph, Listener<RuntimeEnvironment> procedure) {
                SCLContext context = SCLContext.getCurrent();
                Object oldGraph = context.put((Object)"graph", (Object)graph);
                try {
                    if (procedure.safeIsDisposed()) {
                        RuntimeEnvironmentRequest2.getRuntimeEnvironment((EnvironmentSpecification)this.parameter, procedure, null);
                    } else {
                        this.sclListener = new UpdateListenerImpl((EnvironmentSpecification)this.parameter, procedure);
                        this.sclListener.notifyAboutUpdate();
                    }
                }
                finally {
                    context.put((Object)"graph", oldGraph);
                }
            }

            public void unregistered() {
                if (this.sclListener != null) {
                    this.sclListener.stopListening();
                }
            }
        });
    }

    public int hashCode() {
        return 31 * ((Object)((Object)this)).getClass().hashCode() + super.hashCode();
    }

    static class UpdateListenerImpl
    extends UpdateListener {
        final EnvironmentSpecification environmentSpecification;
        final Listener<RuntimeEnvironment> callback;

        UpdateListenerImpl(EnvironmentSpecification environmentSpecification, Listener<RuntimeEnvironment> callback) {
            this.environmentSpecification = environmentSpecification;
            this.callback = callback;
        }

        public void notifyAboutUpdate() {
            if (this.callback.safeIsDisposed()) {
                this.stopListening();
                return;
            }
            RuntimeEnvironmentRequest2.getRuntimeEnvironment(this.environmentSpecification, this.callback, this);
        }
    }
}

