/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.simantics.databoard.type.BooleanType;
import org.simantics.databoard.type.ByteType;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.DoubleType;
import org.simantics.databoard.type.FloatType;
import org.simantics.databoard.type.IntegerType;
import org.simantics.databoard.type.LongType;
import org.simantics.databoard.type.StringType;

public final class PrimitiveValueParser {
    static final Pattern truePattern = Pattern.compile("\\s*1|[tT]([rR]([uU]([eE])?)?)?\\s*");
    static final Pattern falsePattern = Pattern.compile("\\s*0|[fF]([aA]([lL]([sS]([eE])?)?)?)?\\s*");
    static final String fpRegex = "^\\s*[\\x00-\\x20]*[+-]?(NaN|Infinity|(\\p{Digit}+([\\.,]\\p{Digit}*)?|[\\.,]\\p{Digit}+))([eE][+-]?\\p{Digit}+)?\\s*$";
    static final Pattern p = Pattern.compile("^\\s*[\\x00-\\x20]*[+-]?(NaN|Infinity|(\\p{Digit}+([\\.,]\\p{Digit}*)?|[\\.,]\\p{Digit}+))([eE][+-]?\\p{Digit}+)?\\s*$");
    static final Pattern commaPat = Pattern.compile(",");
    public static final IValidator NON_MODIFIABLE_VALIDATOR = new IValidator(){

        @Override
        public String isValid(String value) {
            return "Value not modifiable";
        }
    };

    public static Object parse(String value, Class<?> clazz) throws IllegalArgumentException {
        if (Double.class.equals(clazz)) {
            return PrimitiveValueParser.parseDouble(value);
        }
        if (Float.class.equals(clazz)) {
            return Float.valueOf(PrimitiveValueParser.parseFloat(value));
        }
        if (Integer.class.equals(clazz)) {
            return PrimitiveValueParser.parseInt(value);
        }
        if (Long.class.equals(clazz)) {
            return PrimitiveValueParser.parseLong(value);
        }
        if (Boolean.class.equals(clazz)) {
            return PrimitiveValueParser.parseBoolean(value);
        }
        if (Byte.class.equals(clazz)) {
            return PrimitiveValueParser.parseByte(value);
        }
        if (String.class.equals(clazz)) {
            return value;
        }
        throw new IllegalArgumentException("class=" + String.valueOf(clazz) + ", value='" + value + "'");
    }

    public static Object parse(String value, Datatype datatype) throws IllegalArgumentException {
        if (datatype instanceof DoubleType) {
            return PrimitiveValueParser.parseDouble(value);
        }
        if (datatype instanceof FloatType) {
            return Float.valueOf(PrimitiveValueParser.parseFloat(value));
        }
        if (datatype instanceof IntegerType) {
            return PrimitiveValueParser.parseInt(value);
        }
        if (datatype instanceof LongType) {
            return PrimitiveValueParser.parseLong(value);
        }
        if (datatype instanceof BooleanType) {
            return PrimitiveValueParser.parseBoolean(value);
        }
        if (datatype instanceof ByteType) {
            return PrimitiveValueParser.parseByte(value);
        }
        if (datatype instanceof StringType) {
            return value;
        }
        throw new IllegalArgumentException("datatype=" + String.valueOf(datatype) + ", value='" + value + "'");
    }

    public static double parseDouble(String value) throws IllegalArgumentException {
        Matcher m = p.matcher(value);
        if (!m.find()) {
            throw new IllegalArgumentException(value + " is not a double number");
        }
        String result = m.group();
        if (result != null) {
            return Double.parseDouble(result.replace(',', '.').trim());
        }
        throw new IllegalArgumentException();
    }

    public static double[] parseDoubleArray(String value) throws IllegalArgumentException {
        String[] parts = commaPat.split(value);
        double[] ret = new double[parts.length];
        int i = 0;
        while (i < parts.length) {
            ret[i] = PrimitiveValueParser.parseDouble(parts[i].trim());
            ++i;
        }
        return ret;
    }

    public static float parseFloat(String value) throws IllegalArgumentException {
        Matcher m = p.matcher(value);
        if (!m.find()) {
            throw new IllegalArgumentException(value + " is not a float number");
        }
        String result = m.group();
        if (result != null) {
            return Float.parseFloat(result.replace(',', '.').trim());
        }
        throw new IllegalArgumentException();
    }

    public static float[] parseFloatArray(String value) throws IllegalArgumentException {
        String[] parts = commaPat.split(value);
        float[] ret = new float[parts.length];
        int i = 0;
        while (i < parts.length) {
            ret[i] = PrimitiveValueParser.parseFloat(parts[i].trim());
            ++i;
        }
        return ret;
    }

    public static boolean parseBoolean(String value) throws IllegalArgumentException {
        if (truePattern.matcher(value.trim()).matches()) {
            return true;
        }
        if (falsePattern.matcher(value.trim()).matches()) {
            return false;
        }
        throw new IllegalArgumentException("not a boolean: " + value);
    }

    public static boolean[] parseBooleanArray(String value) {
        String[] parts = commaPat.split(value);
        boolean[] ret = new boolean[parts.length];
        int i = 0;
        while (i < parts.length) {
            ret[i] = PrimitiveValueParser.parseBoolean(parts[i].trim());
            ++i;
        }
        return ret;
    }

    public static byte parseByte(String value) throws IllegalArgumentException {
        try {
            return Byte.parseByte(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static byte[] parseByteArray(String value) {
        String[] parts = commaPat.split(value);
        byte[] ret = new byte[parts.length];
        int i = 0;
        while (i < parts.length) {
            ret[i] = PrimitiveValueParser.parseByte(parts[i]);
            ++i;
        }
        return ret;
    }

    public static int parseInt(String value) throws IllegalArgumentException {
        try {
            return Integer.parseInt(value.trim());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static int[] parseIntArray(String value) {
        String[] parts = commaPat.split(value);
        int[] ret = new int[parts.length];
        int i = 0;
        while (i < parts.length) {
            ret[i] = PrimitiveValueParser.parseInt(parts[i].trim());
            ++i;
        }
        return ret;
    }

    public static long parseLong(String value) throws IllegalArgumentException {
        try {
            return Long.parseLong(value.trim());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static long[] parseLongArray(String value) {
        String[] parts = commaPat.split(value);
        long[] ret = new long[parts.length];
        int i = 0;
        while (i < parts.length) {
            ret[i] = PrimitiveValueParser.parseLong(parts[i].trim());
            ++i;
        }
        return ret;
    }

    public static class BooleanArrayValidator
    extends Validator {
        @Override
        void tryValidate(String v) throws Exception {
            PrimitiveValueParser.parseBooleanArray(v);
        }
    }

    public static class BooleanValidator
    extends Validator {
        @Override
        void tryValidate(String v) throws Exception {
            PrimitiveValueParser.parseBoolean(v.trim());
        }
    }

    public static class ByteArrayValidator
    extends Validator {
        @Override
        public void tryValidate(String v) throws Exception {
            PrimitiveValueParser.parseByteArray(v);
        }
    }

    public static class ByteValidator
    extends Validator {
        @Override
        public void tryValidate(String v) throws Exception {
            Byte.parseByte(v);
        }
    }

    public static class DoubleArrayValidator
    extends Validator {
        @Override
        public void tryValidate(String v) throws Exception {
            PrimitiveValueParser.parseDoubleArray(v);
        }
    }

    public static class DoubleValidator
    extends Validator {
        @Override
        public void tryValidate(String v) throws Exception {
            Double.parseDouble(v.trim());
        }
    }

    public static class FloatArrayValidator
    extends Validator {
        @Override
        public void tryValidate(String v) throws Exception {
            PrimitiveValueParser.parseFloatArray(v);
        }
    }

    public static class FloatValidator
    extends Validator {
        @Override
        public void tryValidate(String v) throws Exception {
            Float.parseFloat(v.trim());
        }
    }

    public static interface IValidator {
        public String isValid(String var1);
    }

    public static class IntegerArrayValidator
    extends Validator {
        @Override
        public void tryValidate(String v) throws Exception {
            PrimitiveValueParser.parseIntArray(v);
        }
    }

    public static class IntegerValidator
    extends Validator {
        @Override
        public void tryValidate(String v) throws Exception {
            Integer.parseInt(v.trim());
        }
    }

    public static class LongArrayValidator
    extends Validator {
        @Override
        public void tryValidate(String v) throws Exception {
            PrimitiveValueParser.parseLongArray(v);
        }
    }

    public static class LongValidator
    extends Validator {
        @Override
        public void tryValidate(String v) throws Exception {
            Long.parseLong(v.trim());
        }
    }

    public static abstract class Validator
    implements IValidator {
        abstract void tryValidate(String var1) throws Exception;

        @Override
        public String isValid(String value) {
            try {
                this.tryValidate(value);
                return null;
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }
    }
}

