/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;

public class EvaluatingListener<T>
implements Listener<T> {
    private volatile Criterion<T> criterion;
    private T result;
    private Throwable exception;
    private Semaphore wait = new Semaphore(0);

    public EvaluatingListener(Criterion<T> criterion) {
        if (criterion == null) {
            throw new NullPointerException("null criterion");
        }
        this.criterion = criterion;
    }

    public static <T> T trySyncRequest(Session session, Read<T> request, Criterion<T> criterion, long timeout, TimeUnit unit) throws InterruptedException, DatabaseException {
        EvaluatingListener<T> l = new EvaluatingListener<T>(criterion);
        session.asyncRequest(request, l);
        l.tryWaitForResult(timeout, unit);
        l.dispose();
        l.throwPossibleException();
        return l.getResult();
    }

    public T waitForResult() throws InterruptedException {
        this.wait.acquire();
        return this.getResult();
    }

    public boolean tryWaitForResult(long timeout, TimeUnit unit) throws InterruptedException {
        return this.wait.tryAcquire(timeout, unit);
    }

    public T getResult() {
        return this.result;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void throwPossibleException() throws DatabaseException {
        if (this.exception != null) {
            if (this.exception instanceof DatabaseException) {
                throw (DatabaseException)this.exception;
            }
            throw new DatabaseException(this.exception);
        }
    }

    public void execute(T result) {
        Criterion<T> crit = this.criterion;
        if (crit == null) {
            return;
        }
        Evaluation e = crit.evaluate(result);
        switch (e) {
            case IGNORE: {
                this.ignored(result);
                return;
            }
            case ACCEPT: {
                this.result = result;
                try {
                    this.accepted(result);
                }
                finally {
                    this.dispose();
                    this.wait.release();
                }
                return;
            }
            case DISCARD: {
                this.dispose();
                this.wait.release();
                return;
            }
        }
    }

    public void ignored(T result) {
    }

    public void accepted(T result) {
    }

    public void exception(Throwable t) {
        this.exception = t;
        this.dispose();
        this.wait.release();
    }

    private void dispose() {
        this.criterion = null;
    }

    public boolean isDisposed() {
        return this.criterion == null;
    }

    public static interface Criterion<T> {
        public Evaluation evaluate(T var1);
    }

    public static enum Evaluation {
        IGNORE,
        DISCARD,
        ACCEPT;

    }
}

