/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.request.combinations;

import java.util.HashMap;
import java.util.Map;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ParametrizedRead;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.combinations.ParametrizedMultiRead;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.procedure.SyncMultiProcedure;
import org.simantics.db.request.MultiRead;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;

public class Combinators {
    public static final ParametrizedRead<Resource, String> NAME = new ParametrizedRead<Resource, String>(){

        public Read<String> get(Resource resource) {
            return Combinators.name(resource);
        }
    };

    public static MultiRead<Resource> objects(Resource subject, Resource relation) {
        return new Objects(subject, relation);
    }

    public static ParametrizedMultiRead<Resource, Resource> relation(Resource relation) {
        return new Relation(relation);
    }

    public static Read<Resource> possibleObject(Resource subject, Resource relation) {
        return new PossibleObject(subject, relation);
    }

    public static ParametrizedRead<Resource, Resource> partialFunction(Resource relation) {
        return new PartialFunction(relation);
    }

    public static Read<Resource> singleObject(Resource subject, Resource relation) {
        return new SingleObject(subject, relation);
    }

    public static ParametrizedRead<Resource, Resource> completeFunction(Resource relation) {
        return new CompleteFunction(relation);
    }

    public static <X, Y> Read<Y> compose(ParametrizedRead<X, Y> f, Read<X> g) {
        return new Compose1<X, Y>(f, g);
    }

    public static <X, Y, Z> ParametrizedRead<X, Z> compose(ParametrizedRead<Y, Z> f, ParametrizedRead<X, Y> g) {
        return new Compose2<X, Y, Z>(f, g);
    }

    public static <X, Y> MultiRead<Y> compose(ParametrizedRead<X, Y> f, MultiRead<X> g) {
        return new Compose3<X, Y>(f, g);
    }

    public static <X, Y, Z> ParametrizedMultiRead<X, Z> compose(ParametrizedRead<Y, Z> f, ParametrizedMultiRead<X, Y> g) {
        return new Compose4<X, Y, Z>(f, g);
    }

    public static <X, Y> MultiRead<Y> compose(ParametrizedMultiRead<X, Y> f, Read<X> g) {
        return new Compose5<X, Y>(f, g);
    }

    public static <X, Y, Z> ParametrizedMultiRead<X, Z> compose(ParametrizedMultiRead<Y, Z> f, ParametrizedRead<X, Y> g) {
        return new Compose6<X, Y, Z>(f, g);
    }

    public static <X, Y> MultiRead<Y> compose(ParametrizedMultiRead<X, Y> f, MultiRead<X> g) {
        return new Compose7<X, Y>(f, g);
    }

    public static <X, Y, Z> ParametrizedMultiRead<X, Z> compose(ParametrizedMultiRead<Y, Z> f, ParametrizedMultiRead<X, Y> g) {
        return new Compose8<X, Y, Z>(f, g);
    }

    public static <K, V> Read<Map<K, V>> index(MultiRead<V> values, ParametrizedRead<V, K> keyOfValue) {
        return new Index<K, V>(values, keyOfValue);
    }

    public static <T> Read<T> constant(T value) {
        return new Constant<T>(value);
    }

    public static <T> MultiRead<T> singleton(T value) {
        return new Singleton<T>(value);
    }

    public static Read<String> name(Resource resource) {
        return new Name(resource);
    }

    private static class CompleteFunction
    implements ParametrizedRead<Resource, Resource> {
        Resource relation;

        public CompleteFunction(Resource relation) {
            this.relation = relation;
        }

        public Read<Resource> get(Resource subject) {
            return Combinators.singleObject(subject, this.relation);
        }

        public int hashCode() {
            return this.getClass().hashCode() + 31 * this.relation.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            CompleteFunction other = (CompleteFunction)obj;
            return this.relation.equals(other.relation);
        }
    }

    private static class Compose1<X, Y>
    implements Read<Y> {
        final ParametrizedRead<X, Y> f;
        final Read<X> g;

        public Compose1(ParametrizedRead<X, Y> f, Read<X> g) {
            this.f = f;
            this.g = g;
        }

        public Y perform(ReadGraph graph) throws DatabaseException {
            return (Y)graph.syncRequest(this.f.get(graph.syncRequest(this.g)));
        }

        public int hashCode() {
            return this.getClass().hashCode() + 31 * (this.f.hashCode() + 31 * this.g.hashCode());
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Compose1 other = (Compose1)obj;
            return this.f.equals(other.f) && this.g.equals(other.g);
        }
    }

    private static class Compose2<X, Y, Z>
    implements ParametrizedRead<X, Z> {
        final ParametrizedRead<Y, Z> f;
        final ParametrizedRead<X, Y> g;

        public Compose2(ParametrizedRead<Y, Z> f, ParametrizedRead<X, Y> g) {
            this.f = f;
            this.g = g;
        }

        public Read<Z> get(X x) {
            return Combinators.compose(this.f, this.g.get(x));
        }

        public int hashCode() {
            return this.getClass().hashCode() + 31 * (this.f.hashCode() + 31 * this.g.hashCode());
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Compose2 other = (Compose2)obj;
            return this.f.equals(other.f) && this.g.equals(other.g);
        }
    }

    private static class Compose3<X, Y>
    implements MultiRead<Y> {
        final ParametrizedRead<X, Y> f;
        final MultiRead<X> g;

        public Compose3(ParametrizedRead<X, Y> f, MultiRead<X> g) {
            this.f = f;
            this.g = g;
        }

        public void perform(ReadGraph graph, SyncMultiProcedure<Y> callback) throws DatabaseException {
            try {
                for (Object x : graph.syncRequest(this.g)) {
                    callback.execute(graph, graph.syncRequest(this.f.get(x)));
                }
                callback.finished(graph);
            }
            catch (DatabaseException e) {
                callback.exception(graph, (Throwable)e);
            }
        }

        public int hashCode() {
            return this.getClass().hashCode() + 31 * (this.f.hashCode() + 31 * this.g.hashCode());
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Compose3 other = (Compose3)obj;
            return this.f.equals(other.f) && this.g.equals(other.g);
        }
    }

    private static class Compose4<X, Y, Z>
    implements ParametrizedMultiRead<X, Z> {
        final ParametrizedRead<Y, Z> f;
        final ParametrizedMultiRead<X, Y> g;

        public Compose4(ParametrizedRead<Y, Z> f, ParametrizedMultiRead<X, Y> g) {
            this.f = f;
            this.g = g;
        }

        @Override
        public MultiRead<Z> get(X x) {
            return Combinators.compose(this.f, this.g.get(x));
        }

        public int hashCode() {
            return this.getClass().hashCode() + 31 * (this.f.hashCode() + 31 * this.g.hashCode());
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Compose4 other = (Compose4)obj;
            return this.f.equals(other.f) && this.g.equals(other.g);
        }
    }

    private static class Compose5<X, Y>
    implements MultiRead<Y> {
        final ParametrizedMultiRead<X, Y> f;
        final Read<X> g;

        public Compose5(ParametrizedMultiRead<X, Y> f, Read<X> g) {
            this.f = f;
            this.g = g;
        }

        public void perform(ReadGraph graph, SyncMultiProcedure<Y> callback) throws DatabaseException {
            graph.syncRequest(this.f.get(graph.syncRequest(this.g)), callback);
        }

        public int hashCode() {
            return this.getClass().hashCode() + 31 * (this.f.hashCode() + 31 * this.g.hashCode());
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Compose5 other = (Compose5)obj;
            return this.f.equals(other.f) && this.g.equals(other.g);
        }
    }

    private static class Compose6<X, Y, Z>
    implements ParametrizedMultiRead<X, Z> {
        final ParametrizedMultiRead<Y, Z> f;
        final ParametrizedRead<X, Y> g;

        public Compose6(ParametrizedMultiRead<Y, Z> f, ParametrizedRead<X, Y> g) {
            this.f = f;
            this.g = g;
        }

        @Override
        public MultiRead<Z> get(X x) {
            return Combinators.compose(this.f, this.g.get(x));
        }

        public int hashCode() {
            return this.getClass().hashCode() + 31 * (this.f.hashCode() + 31 * this.g.hashCode());
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Compose6 other = (Compose6)obj;
            return this.f.equals(other.f) && this.g.equals(other.g);
        }
    }

    private static class Compose7<X, Y>
    implements MultiRead<Y> {
        final ParametrizedMultiRead<X, Y> f;
        final MultiRead<X> g;

        public Compose7(ParametrizedMultiRead<X, Y> f, MultiRead<X> g) {
            this.f = f;
            this.g = g;
        }

        public void perform(ReadGraph graph, SyncMultiProcedure<Y> callback) throws DatabaseException {
            try {
                for (Object x : graph.syncRequest(this.g)) {
                    for (Object y : graph.syncRequest(this.f.get(x))) {
                        callback.execute(graph, y);
                    }
                }
                callback.finished(graph);
            }
            catch (DatabaseException e) {
                callback.exception(graph, (Throwable)e);
            }
        }

        public int hashCode() {
            return this.getClass().hashCode() + 31 * (this.f.hashCode() + 31 * this.g.hashCode());
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Compose7 other = (Compose7)obj;
            return this.f.equals(other.f) && this.g.equals(other.g);
        }
    }

    private static class Compose8<X, Y, Z>
    implements ParametrizedMultiRead<X, Z> {
        final ParametrizedMultiRead<Y, Z> f;
        final ParametrizedMultiRead<X, Y> g;

        public Compose8(ParametrizedMultiRead<Y, Z> f, ParametrizedMultiRead<X, Y> g) {
            this.f = f;
            this.g = g;
        }

        @Override
        public MultiRead<Z> get(X x) {
            return Combinators.compose(this.f, this.g.get(x));
        }

        public int hashCode() {
            return this.getClass().hashCode() + 31 * (this.f.hashCode() + 31 * this.g.hashCode());
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Compose8 other = (Compose8)obj;
            return this.f.equals(other.f) && this.g.equals(other.g);
        }
    }

    private static class Constant<T>
    implements Read<T> {
        T value;

        public Constant(T value) {
            this.value = value;
        }

        public T perform(ReadGraph graph) throws DatabaseException {
            return this.value;
        }

        public int hashCode() {
            return this.value == null ? 0 : this.value.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Constant other = (Constant)obj;
            return this.value == null ? other.value == null : this.value.equals(other.value);
        }
    }

    private static class Index<K, V>
    implements Read<Map<K, V>> {
        final MultiRead<V> values;
        final ParametrizedRead<V, K> keyOfValue;

        public Index(MultiRead<V> values, ParametrizedRead<V, K> keyOfValue) {
            this.values = values;
            this.keyOfValue = keyOfValue;
        }

        public Map<K, V> perform(ReadGraph graph) throws DatabaseException {
            HashMap result = new HashMap();
            for (Object value : graph.syncRequest(this.values)) {
                result.put(graph.syncRequest(this.keyOfValue.get(value)), value);
            }
            return result;
        }

        public int hashCode() {
            return this.getClass().hashCode() + 31 * (this.values.hashCode() + 31 * this.keyOfValue.hashCode());
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Index other = (Index)obj;
            return this.values.equals(other.values) && this.keyOfValue.equals(other.keyOfValue);
        }
    }

    private static class Name
    extends ResourceRead<String> {
        public Name(Resource resource) {
            super(resource);
        }

        public String perform(ReadGraph graph) throws DatabaseException {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            return (String)graph.getRelatedValue(this.resource, L0.HasName);
        }
    }

    private static class Objects
    implements MultiRead<Resource> {
        Resource subject;
        Resource relation;

        public Objects(Resource subject, Resource relation) {
            this.subject = subject;
            this.relation = relation;
        }

        public void perform(ReadGraph graph, SyncMultiProcedure<Resource> callback) throws DatabaseException {
            for (Resource object : graph.getObjects(this.subject, this.relation)) {
                callback.execute(graph, (Object)object);
            }
        }

        public int hashCode() {
            return this.subject.hashCode() + 31 * this.relation.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Objects other = (Objects)object;
            return this.subject.equals(other.subject) && this.relation.equals(other.relation);
        }
    }

    private static class PartialFunction
    implements ParametrizedRead<Resource, Resource> {
        Resource relation;

        public PartialFunction(Resource relation) {
            this.relation = relation;
        }

        public Read<Resource> get(Resource subject) {
            return Combinators.possibleObject(subject, this.relation);
        }

        public int hashCode() {
            return this.getClass().hashCode() + 31 * this.relation.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            PartialFunction other = (PartialFunction)obj;
            return this.relation.equals(other.relation);
        }
    }

    private static class PossibleObject
    implements Read<Resource> {
        Resource subject;
        Resource relation;

        public PossibleObject(Resource subject, Resource relation) {
            this.subject = subject;
            this.relation = relation;
        }

        public Resource perform(ReadGraph graph) throws DatabaseException {
            return graph.getPossibleObject(this.subject, this.relation);
        }

        public int hashCode() {
            return this.subject.hashCode() + 31 * this.relation.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            PossibleObject other = (PossibleObject)object;
            return this.subject.equals(other.subject) && this.relation.equals(other.relation);
        }
    }

    private static class Relation
    implements ParametrizedMultiRead<Resource, Resource> {
        Resource relation;

        public Relation(Resource relation) {
            this.relation = relation;
        }

        @Override
        public MultiRead<Resource> get(Resource subject) {
            return Combinators.objects(subject, this.relation);
        }

        public int hashCode() {
            return this.getClass().hashCode() + 31 * this.relation.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Relation other = (Relation)obj;
            return this.relation.equals(other.relation);
        }
    }

    private static class SingleObject
    implements Read<Resource> {
        Resource subject;
        Resource relation;

        public SingleObject(Resource subject, Resource relation) {
            this.subject = subject;
            this.relation = relation;
        }

        public Resource perform(ReadGraph graph) throws DatabaseException {
            return graph.getSingleObject(this.subject, this.relation);
        }

        public int hashCode() {
            return this.subject.hashCode() + 31 * this.relation.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            SingleObject other = (SingleObject)object;
            return this.subject.equals(other.subject) && this.relation.equals(other.relation);
        }
    }

    private static class Singleton<T>
    implements MultiRead<T> {
        T value;

        public Singleton(T value) {
            this.value = value;
        }

        public void perform(ReadGraph graph, SyncMultiProcedure<T> callback) throws DatabaseException {
            callback.execute(graph, this.value);
            callback.finished(graph);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Singleton other = (Singleton)obj;
            return this.value.equals(other.value);
        }
    }

    public static class SynchronizationProcedure<T>
    implements Procedure<T> {
        T result;
        DatabaseException exception;
        boolean ready = false;

        public synchronized void exception(Throwable t) {
            this.exception = t instanceof DatabaseException ? (DatabaseException)t : new DatabaseException(t);
            this.ready = true;
            this.notify();
        }

        public synchronized void execute(T result) {
            this.result = result;
            this.ready = true;
            this.notify();
        }

        public synchronized T getResult() throws DatabaseException {
            if (!this.ready) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new DatabaseException((Throwable)e);
                }
            }
            if (this.exception != null) {
                throw this.exception;
            }
            return this.result;
        }
    }
}

