/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.request;

import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.NoSingleResultException;
import org.simantics.db.layer0.request.ActiveModels;
import org.simantics.db.request.Read;

public class SingleActiveModel
extends ResourceRead<Resource> {
    public SingleActiveModel(Resource project) {
        super(project);
    }

    public Resource perform(ReadGraph graph) throws DatabaseException {
        Collection actives = (Collection)graph.syncRequest((Read)new ActiveModels(this.resource));
        if (actives.size() == 1) {
            return (Resource)actives.iterator().next();
        }
        if (actives.size() == 0) {
            throw new NoSingleResultException("There are no active models.", actives.size());
        }
        throw new NoSingleResultException("There are many active models: " + NameUtils.getSafeName((ReadGraph)graph, (Collection)actives), actives.size());
    }
}

