/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.SessionModel;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;
import org.simantics.user.UserResource;

public class SetActiveSessionRole
extends WriteRequest {
    private final Resource model;
    private final Resource role;

    public SetActiveSessionRole(RequestProcessor processor, Resource model, Resource role) {
        super(((VirtualGraphSupport)processor.getService(VirtualGraphSupport.class)).getWorkspacePersistent("activations"));
        this.model = model;
        this.role = role;
    }

    public void perform(WriteGraph graph) throws DatabaseException {
        Resource selection2;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        UserResource USER = UserResource.getInstance((ReadGraph)graph);
        Resource session = ((SessionModel)graph.getService(SessionModel.class)).getResource();
        if (session != null) {
            for (Resource selection2 : graph.getObjects(session, L0X.Session_HasRoleSelection)) {
                Resource selectionModel = graph.getPossibleObject(selection2, USER.RoleSelection_HasModel);
                if (!selectionModel.equals(this.model)) continue;
                graph.deny(selection2, USER.RoleSelection_HasRole);
                graph.claim(selection2, USER.RoleSelection_HasRole, this.role);
                return;
            }
        }
        selection2 = graph.newResource();
        graph.claim(selection2, L0.InstanceOf, null, USER.RoleSelection);
        graph.claim(selection2, USER.RoleSelection_HasModel, this.model);
        graph.claim(selection2, USER.RoleSelection_HasRole, this.role);
        graph.claim(session, L0X.Session_HasRoleSelection, selection2);
    }
}

