/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.request;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.TernaryRead;
import org.simantics.db.exception.AdaptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.layer0.adapter.Valuations;
import org.simantics.db.layer0.request.PossibleDiagram;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.scl.reflection.OntologyVersions;
import org.simantics.simulation.ontology.SimulationResource;

public class PossibleSessionValuation
extends TernaryRead<Resource, String, String, Resource> {
    public PossibleSessionValuation(Resource resource, String identifier) {
        super((Object)resource, (Object)identifier, (Object)"");
    }

    public PossibleSessionValuation(Resource resource, String identifier, String suffix) {
        super((Object)resource, (Object)identifier, (Object)suffix);
    }

    public Resource perform(ReadGraph graph) throws DatabaseException {
        try {
            Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
            String valuationName = null;
            Valuations valuations = (Valuations)graph.adapt((Resource)this.parameter, Valuations.class);
            String uri = OntologyVersions.getInstance().currentVersion("http://www.simantics.org/Modeling-0.0/CompositeToDiagram");
            Resource map = graph.getResource(uri);
            Resource diagram = (Resource)graph.syncRequest((Read)new PossibleDiagram((Resource)this.parameter));
            if (diagram == null) {
                Resource d = (Resource)this.parameter;
                while ((d = graph.getPossibleObject(d, l0.PartOf)) != null) {
                    diagram = graph.getPossibleObject(d, map);
                    if (diagram != null) break;
                }
            }
            if (diagram != null) {
                SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
                for (Resource run : graph.getObjects(diagram, l0.ConsistsOf)) {
                    String name = (String)graph.getPossibleRelatedValue(run, l0.HasName, (Binding)Bindings.STRING);
                    if (!((String)this.parameter2).equals(name)) continue;
                    valuationName = (String)graph.getPossibleRelatedValue(run, SIMU.HasActiveExperiment);
                    break;
                }
            }
            Resource value = valuations.getValue(graph, null, valuationName, (String)this.parameter3);
            return graph.getSingleObject(value, l0.ConsistsOf);
        }
        catch (ResourceNotFoundException e) {
            return null;
        }
        catch (AdaptionException e) {
            return null;
        }
    }
}

