/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.migration;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.container.DataContainer;
import org.simantics.databoard.container.DataContainers;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.primitiverequest.PossibleResource;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.common.request.FreshEscapedName;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.common.utils.VersionMap;
import org.simantics.db.common.utils.VersionMapRequest;
import org.simantics.db.common.utils.Versions;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.layer0.adapter.impl.DefaultPasteHandler;
import org.simantics.db.layer0.adapter.impl.SharedOntologyImportAdvisor;
import org.simantics.db.layer0.adapter.impl.TrashBinRemover;
import org.simantics.db.layer0.internal.SimanticsInternal;
import org.simantics.db.layer0.migration.MigratedImportResult;
import org.simantics.db.layer0.migration.MigrationState;
import org.simantics.db.layer0.migration.MigrationStateImpl;
import org.simantics.db.layer0.migration.MigrationStep;
import org.simantics.db.layer0.request.ActivateModel;
import org.simantics.db.layer0.util.ExternalDownloadBean;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.util.TGTransferableGraphSource;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.Write;
import org.simantics.db.service.XSupport;
import org.simantics.graph.db.IImportAdvisor;
import org.simantics.graph.db.ImportResult;
import org.simantics.graph.db.MissingDependencyException;
import org.simantics.graph.db.TransferableGraphException;
import org.simantics.graph.representation.Root;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.representation.TransferableGraphUtils;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.datastructures.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrationUtils.class);
    public static final boolean DEBUG = false;

    public static MigrationState newState() {
        return new MigrationStateImpl();
    }

    public static MigrationStep getStep(Session session, String uri) throws DatabaseException {
        return (MigrationStep)session.sync((ReadInterface)new UnaryRead<String, MigrationStep>(uri){

            public MigrationStep perform(ReadGraph graph) throws DatabaseException {
                Resource r = graph.getResource((String)this.parameter);
                return (MigrationStep)graph.adapt(r, MigrationStep.class);
            }
        });
    }

    public static void clearTempResource(Session session, Resource resource) {
        session.asyncRequest(graph -> graph.deny(resource, Layer0.getInstance((ReadGraph)graph).PartOf));
    }

    private static void activateIfNoActiveModel(WriteGraph graph, Resource root, Resource parent) throws DatabaseException {
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        if (!graph.hasStatement(parent, L0X.Activates) && graph.isInstanceOf(root, SIMU.Model)) {
            new ActivateModel(parent, root).perform(graph);
        }
    }

    public static Collection<Resource> importTo(IProgressMonitor monitor, Session session, final MigrationState state, final Resource parent, final IImportAdvisor advisor) throws DatabaseException, TransferableGraphException {
        final Resource resource = MigrationUtils.getResource(monitor, session, state);
        final ArrayList<Resource> result = new ArrayList<Resource>();
        VirtualGraph vg = (VirtualGraph)state.getProperty("vg");
        if (resource != null) {
            session.syncRequest((Write)new WriteRequest(vg){

                public void perform(WriteGraph graph) throws DatabaseException {
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    for (Resource root : graph.getObjects(resource, L0.ConsistsOf)) {
                        String baseName = Versions.getBaseName((ReadGraph)graph, (Resource)root);
                        String version = Versions.getVersion((ReadGraph)graph, (Resource)root);
                        if (version != null) {
                            VersionMap map = (VersionMap)graph.syncRequest((Read)new VersionMapRequest(parent));
                            if (map.contains(baseName, version)) {
                                String newName = (String)graph.syncRequest((Read)new FreshEscapedName(parent, L0.ConsistsOf, baseName));
                                graph.claimLiteral(root, L0.HasName, (Object)(newName + "@1"), (Binding)Bindings.STRING);
                            }
                        } else {
                            String newName = (String)graph.syncRequest((Read)new FreshEscapedName(parent, L0.ConsistsOf, baseName));
                            if (!newName.equals(baseName)) {
                                graph.claimLiteral(root, L0.HasName, (Object)newName, (Binding)Bindings.STRING);
                            }
                        }
                        graph.deny(root, L0.PartOf);
                        graph.claim(root, L0.PartOf, parent);
                        if (Boolean.TRUE.equals(state.getProperty("ActivateRootIfNoneActive"))) {
                            MigrationUtils.activateIfNoActiveModel(graph, root, parent);
                        }
                        CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
                        graph.addMetadata((Metadata)cm.add("Imported " + graph.getURI(root) + ", resource " + String.valueOf(root)));
                        result.add(root);
                    }
                    graph.deny(resource, L0.PartOf);
                }
            });
        } else {
            final TransferableGraph1 tg = MigrationUtils.getTG(session, state);
            if (tg != null) {
                final IImportAdvisor _advisor = new IImportAdvisor(){

                    public Resource createRoot(WriteOnlyGraph graph, Root root) throws DatabaseException {
                        Resource r = advisor.createRoot(graph, root);
                        result.add(r);
                        return r;
                    }

                    public Resource analyzeRoot(ReadGraph graph, Root root) throws DatabaseException {
                        return advisor.analyzeRoot(graph, root);
                    }
                };
                if (vg == null) {
                    DefaultPasteHandler.defaultExecute(tg, parent, _advisor);
                } else {
                    session.syncRequest((Write)new WriteRequest(vg){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            DefaultPasteHandler.defaultExecute(graph, tg, parent, _advisor);
                        }
                    });
                }
            }
        }
        return result;
    }

    public static Collection<MigrationStep> getMigrationSteps(DataContainer header) throws DatabaseException {
        return (Collection)SimanticsInternal.sync((ReadInterface)new BinaryRead<String, Integer, Collection<MigrationStep>>(header.format, Integer.valueOf(header.version)){

            public Collection<MigrationStep> perform(ReadGraph graph) throws DatabaseException {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                ArrayList<Pair> steps = new ArrayList<Pair>();
                Instances query = (Instances)graph.adapt(L0.Migration, Instances.class);
                HashSet<Resource> migrations = new HashSet<Resource>();
                for (Resource ontology : Layer0Utils.listOntologies(graph)) {
                    migrations.addAll(Layer0Utils.sortByCluster(graph, query.find(graph, ontology)));
                }
                for (Resource migration : migrations) {
                    String format = (String)graph.getRelatedValue(migration, L0.Migration_format);
                    if (!((String)this.parameter).equals(format)) continue;
                    Integer from = (Integer)graph.getRelatedValue(migration, L0.Migration_from);
                    Resource step = graph.getSingleObject(migration, L0.Migration_step);
                    if (!((Integer)this.parameter2).equals(from)) continue;
                    Double priority = (Double)graph.getRelatedValue(migration, L0.Migration_priority);
                    MigrationStep code = (MigrationStep)graph.getPossibleAdapter(step, MigrationStep.class);
                    if (code != null) {
                        steps.add(Pair.make((Object)(-priority.doubleValue()), (Object)code));
                        continue;
                    }
                    LOGGER.error("Failed to find an implementation for migration step " + NameUtils.getURIOrSafeNameInternal((ReadGraph)graph, (Resource)step));
                }
                return CollectionUtils.sortByFirst(steps);
            }
        });
    }

    public static Resource importMigrated(IProgressMonitor monitor, Session session, File modelFile, MigrationState state, IImportAdvisor advisor, Resource target) throws Exception {
        return MigrationUtils.importMigrated(monitor, session, null, modelFile, state, advisor, target);
    }

    public static Resource importMigrated(IProgressMonitor monitor, Session session, VirtualGraph vg, File modelFile, MigrationState state, IImportAdvisor advisor, Resource target) throws Exception {
        Collection<Resource> roots = MigrationUtils.importMigratedMany(monitor, session, vg, modelFile, state, advisor, target);
        if (roots.size() == 1) {
            return roots.iterator().next();
        }
        return null;
    }

    public static Collection<Resource> importMigratedMany(IProgressMonitor monitor, Session session, File modelFile, MigrationState state, IImportAdvisor advisor, Resource target) throws Exception {
        return MigrationUtils.importMigratedMany(monitor, session, null, modelFile, state, advisor, target);
    }

    public static Collection<Resource> importMigratedMany(IProgressMonitor monitor, Session session, VirtualGraph vg, File modelFile, MigrationState state, IImportAdvisor advisor, Resource target) throws Exception {
        assert (advisor != null);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        state.setProperty("modelFile", modelFile);
        state.setProperty("session", session);
        state.setProperty("progressMonitor", monitor);
        state.setProperty("importAdvisor", advisor);
        if (vg != null) {
            state.setProperty("vg", vg);
        }
        DataContainer dc = (DataContainer)state.getProperty("currentDataContainer");
        Collection<MigrationStep> migration = MigrationUtils.getMigrationSteps(dc);
        for (MigrationStep step : migration) {
            step.applyTo(monitor, session, state);
            if (monitor.isCanceled()) break;
        }
        if (monitor.isCanceled()) {
            final Resource root = (Resource)state.probeProperty("currentResource");
            if (root != null) {
                session.syncRequest((Write)new WriteRequest(vg){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        new TrashBinRemover(root).remove(graph);
                    }
                });
            }
            return Collections.emptyList();
        }
        if (target == null) {
            Collection roots = (Collection)state.getProperty("currentRootResources");
            return roots;
        }
        return MigrationUtils.importTo(monitor, session, state, target, advisor);
    }

    public static TransferableGraph1 getTG(Session session, MigrationState state) throws DatabaseException {
        return (TransferableGraph1)state.getProperty("currentTG");
    }

    public static Resource getResource(IProgressMonitor monitor, Session session, MigrationState state) throws DatabaseException {
        return (Resource)state.getProperty("currentResource");
    }

    public static Collection<Resource> getRootResources(IProgressMonitor monitor, Session session, MigrationState state) throws DatabaseException {
        return (Collection)state.getProperty("currentRootResources");
    }

    public static <T> T getProperty(MigrationState state, String key, T defaultValue) throws DatabaseException {
        Object t = state.getProperty(key);
        return t != null ? t : defaultValue;
    }

    public static MigratedImportResult importSharedOntology(Session session, TransferableGraph1 tg, boolean published) throws DatabaseException {
        return MigrationUtils.importSharedOntology(null, session, tg, published);
    }

    public static MigratedImportResult importSharedOntology(IProgressMonitor monitor, Session session, TransferableGraph1 tg, boolean published) throws DatabaseException {
        Collection roots;
        Variant edbVariant;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ((edbVariant = (Variant)tg.extensions.get(ExternalDownloadBean.EXTENSION_KEY)) != null) {
            try {
                ExternalDownloadBean edb = (ExternalDownloadBean)edbVariant.getValue(ExternalDownloadBean.BINDING);
                for (Map.Entry<String, String> entry : edb.downloads.entrySet()) {
                    String uri = entry.getKey();
                    Resource existing = (Resource)session.syncRequest((Read)new PossibleResource(uri));
                    if (existing != null) continue;
                    String download = entry.getValue();
                    URL url = new URL(download);
                    DataContainer container = DataContainers.readFile((DataInput)new DataInputStream(url.openStream()));
                    TransferableGraph1 dependencyTg = (TransferableGraph1)container.content.getValue(TransferableGraph1.BINDING);
                    MigrationUtils.importSharedOntology(monitor, session, dependencyTg, true);
                }
            }
            catch (AdaptException e) {
                throw new DatabaseException((Throwable)e);
            }
            catch (MalformedURLException e) {
                throw new DatabaseException((Throwable)e);
            }
            catch (IOException e) {
                throw new DatabaseException((Throwable)e);
            }
        }
        if ((roots = TransferableGraphUtils.getRoots((TransferableGraph1)tg)).size() == 1) {
            MigrationState state = MigrationUtils.newState();
            try {
                TGTransferableGraphSource tgSource = new TGTransferableGraphSource(tg);
                SharedOntologyImportAdvisor advisor = new SharedOntologyImportAdvisor(published);
                state.setProperty("updateDependencies", false);
                state.setProperty("currentTGS", tgSource);
                state.setProperty("session", session);
                state.setProperty("progressMonitor", monitor);
                state.setProperty("currentDataContainer", new DataContainer("sharedLibrary", 1, new Variant(TransferableGraph1.BINDING, (Object)tg)));
                MigrationUtils.importMigrated(monitor, session, null, state, (IImportAdvisor)advisor, null);
                Collection resultRoots = (Collection)state.getProperty("currentRootResources");
                ImportResult result = (ImportResult)state.getProperty("importResult");
                MigratedImportResult migratedImportResult = new MigratedImportResult(resultRoots, result);
                return migratedImportResult;
            }
            catch (TransferableGraphException e) {
                throw new DatabaseException((Throwable)e);
            }
            catch (MissingDependencyException e) {
                throw e;
            }
            catch (DatabaseException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DatabaseException((Throwable)e);
            }
            finally {
                state.dispose();
                ((XSupport)session.getService(XSupport.class)).setServiceMode(false, false);
            }
        }
        return null;
    }
}

