/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.adapter.impl;

import java.lang.reflect.Array;
import java.util.List;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.parser.repository.DataTypeSyntaxError;
import org.simantics.databoard.parser.repository.DataValueRepository;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.RecordType;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.layer0.adapter.StringIndexModifier;
import org.simantics.db.layer0.adapter.TObjectIntPair;
import org.simantics.db.layer0.util.PrimitiveValueParser;
import org.simantics.db.request.Write;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.layer0.Layer0;

public final class StringIndexModifierImpl
implements StringIndexModifier {
    final Resource resource;
    PrimitiveValueParser.IValidator validator;

    public StringIndexModifierImpl(ReadGraph g, Resource resource) throws DatabaseException {
        this.resource = resource;
        this.validator = null;
        Layer0 l0 = Layer0.getInstance((ReadGraph)g);
        if (g.isInstanceOf(resource, l0.DoubleArray)) {
            this.validator = new PrimitiveValueParser.DoubleValidator();
        } else if (g.isInstanceOf(resource, l0.ByteArray)) {
            this.validator = new PrimitiveValueParser.ByteValidator();
        } else if (g.isInstanceOf(resource, l0.BooleanArray)) {
            this.validator = new PrimitiveValueParser.BooleanValidator();
        } else if (g.isInstanceOf(resource, l0.IntegerArray)) {
            this.validator = new PrimitiveValueParser.IntegerValidator();
        } else if (g.isInstanceOf(resource, l0.LongArray)) {
            this.validator = new PrimitiveValueParser.LongValidator();
        } else if (g.isInstanceOf(resource, l0.FloatArray)) {
            this.validator = new PrimitiveValueParser.FloatValidator();
        }
    }

    @Override
    public String getValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String isValid(TObjectIntPair<String> value) {
        return this.validator == null ? null : this.validator.isValid((String)value.first);
    }

    @Override
    public void modify(WriteGraph graph, final TObjectIntPair<String> pair) throws DatabaseException {
        VirtualGraphSupport vgs = (VirtualGraphSupport)graph.getService(VirtualGraphSupport.class);
        VirtualGraph vg = vgs.getGraph((ReadGraph)graph, this.resource);
        if (vg != null) {
            graph.syncRequest((Write)new WriteRequest(vg){

                public void perform(WriteGraph graph) throws DatabaseException {
                    StringIndexModifierImpl.this.modify0(graph, pair);
                }
            });
        } else {
            this.modify0(graph, pair);
        }
    }

    public void modify0(WriteGraph graph, TObjectIntPair<String> pair) throws DatabaseException {
        block15: {
            Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
            String value = (String)pair.first;
            int index = pair.second;
            try {
                if (graph.isInstanceOf(this.resource, l0.StringArray)) {
                    String[] old = (String[])graph.getValue(this.resource);
                    old[index] = value;
                    graph.claimValue(this.resource, (Object)old);
                    break block15;
                }
                if (graph.isInstanceOf(this.resource, l0.DoubleArray)) {
                    double[] old = (double[])graph.getValue(this.resource);
                    old[index] = PrimitiveValueParser.parseDouble(value);
                    graph.claimValue(this.resource, (Object)old);
                    break block15;
                }
                if (graph.isInstanceOf(this.resource, l0.ByteArray)) {
                    byte[] old = (byte[])graph.getValue(this.resource);
                    old[index] = PrimitiveValueParser.parseByte(value);
                    graph.claimValue(this.resource, (Object)old);
                    break block15;
                }
                if (graph.isInstanceOf(this.resource, l0.BooleanArray)) {
                    boolean[] old = (boolean[])graph.getValue(this.resource);
                    old[index] = PrimitiveValueParser.parseBoolean(value);
                    graph.claimValue(this.resource, (Object)old);
                    break block15;
                }
                if (graph.isInstanceOf(this.resource, l0.IntegerArray)) {
                    int[] old = (int[])graph.getValue(this.resource);
                    old[index] = PrimitiveValueParser.parseInt(value);
                    graph.claimValue(this.resource, (Object)old);
                    break block15;
                }
                if (graph.isInstanceOf(this.resource, l0.LongArray)) {
                    long[] old = (long[])graph.getValue(this.resource);
                    old[index] = PrimitiveValueParser.parseLong(value);
                    graph.claimValue(this.resource, (Object)old);
                    break block15;
                }
                if (graph.isInstanceOf(this.resource, l0.FloatArray)) {
                    float[] old = (float[])graph.getValue(this.resource);
                    old[index] = PrimitiveValueParser.parseFloat(value);
                    graph.claimValue(this.resource, (Object)old);
                    break block15;
                }
                if (graph.isInstanceOf(this.resource, l0.OrderedSet)) {
                    List list = OrderedSetUtils.toList((ReadGraph)graph, (Resource)this.resource);
                    Resource el = graph.newResource();
                    graph.claimValue(el, (Object)value);
                    graph.claim(el, l0.InstanceOf, null, l0.String);
                    OrderedSetUtils.replace((WriteGraph)graph, (Resource)this.resource, (Resource)((Resource)list.get(index)), (Resource)el);
                    break block15;
                }
                Datatype dt = (Datatype)graph.getPossibleRelatedValue(this.resource, l0.HasDataType, Bindings.getBindingUnchecked(Datatype.class));
                if (dt instanceof RecordType) {
                    RecordType rt = (RecordType)dt;
                    RecordBinding rb = (RecordBinding)Bindings.getBinding((Datatype)rt);
                    Binding indexBinding = rb.getComponentBinding(index);
                    Object parsedValue = indexBinding.parseValue(value, new DataValueRepository());
                    Object v = graph.getValue(this.resource, (Binding)rb);
                    rb.setComponent(v, index, parsedValue);
                    graph.claimValue(this.resource, v, (Binding)rb);
                    break block15;
                }
                if (dt instanceof ArrayType) {
                    ArrayType at = (ArrayType)dt;
                    Binding binding = Bindings.getBinding((Datatype)at);
                    Binding indexBinding = Bindings.getBinding((Datatype)at.componentType());
                    Object parsedValue = indexBinding.parseValue(value, new DataValueRepository());
                    Object v = graph.getValue(this.resource, binding);
                    if (v.getClass().isArray()) {
                        Array.set(v, index, parsedValue);
                        graph.claimValue(this.resource, v, binding);
                    }
                    break block15;
                }
                throw new ValidationException("Could not modify unrecognized resource '" + NameUtils.getSafeName((ReadGraph)graph, (Resource)this.resource) + "' with value " + value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (DataTypeSyntaxError e) {
                throw new ValidationException("Could not modify unrecognized resource '" + NameUtils.getSafeName((ReadGraph)graph, (Resource)this.resource) + "' with value " + value, (Throwable)e);
            }
            catch (BindingException e) {
                throw new ValidationException("Could not modify unrecognized resource '" + NameUtils.getSafeName((ReadGraph)graph, (Resource)this.resource) + "' with value " + value, (Throwable)e);
            }
        }
    }
}

