/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.adapter.impl;

import java.util.Collection;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Remover;
import org.simantics.db.layer0.adapter.impl.AbstractRemover;
import org.simantics.db.layer0.exception.CannotRemoveException;
import org.simantics.db.layer0.request.IsContainerPublished;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.db.service.XSupport;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.Pair;

public class EntityRemover
extends AbstractRemover {
    public EntityRemover(Resource resource) {
        super(resource);
    }

    @Override
    public void remove(WriteGraph graph) throws DatabaseException {
        EntityRemover.remove(graph, this.resource, true);
    }

    public static void remove(WriteGraph graph, Resource resource) throws DatabaseException {
        EntityRemover.remove(graph, resource, true);
    }

    public static void remove(WriteGraph graph, Resource resource, boolean useAdapters) throws DatabaseException {
        boolean published;
        if (graph.isImmutable(resource)) {
            XSupport xs = (XSupport)graph.getService(XSupport.class);
            Pair sm = xs.getServiceMode();
            if (Boolean.FALSE.equals(sm.first)) {
                throw new CannotRemoveException("Cannot remove immutable resources (" + String.valueOf(resource) + ")");
            }
        }
        if (published = ((Boolean)graph.syncRequest((Read)new IsContainerPublished(resource), (AsyncProcedure)TransientCacheAsyncListener.instance())).booleanValue()) {
            throw new CannotRemoveException("Items in published libraries cannot be removed. Please create a new version to perform modifications.");
        }
        Layer0 l0 = (Layer0)graph.l0();
        Collection stms = graph.getStatements(resource, l0.IsWeaklyRelatedTo);
        Resource[] composedOf = null;
        int cn = 0;
        for (Statement stm : stms) {
            Resource partOf;
            Resource subject = stm.getSubject();
            if (!resource.equalsResource(subject)) continue;
            Resource predicate = stm.getPredicate();
            Resource object = stm.getObject();
            Resource inverse = graph.getPossibleInverse(predicate);
            graph.deny(subject, predicate, inverse, object);
            if (resource.equalsResource(object) || !graph.isSubrelationOf(predicate, l0.IsComposedOf) || graph.isSubrelationOf(predicate, l0.HasProperty) && (partOf = graph.getPossibleObject(object, l0.PartOf)) != null && !partOf.equalsResource(resource)) continue;
            if (composedOf == null) {
                composedOf = new Resource[stms.size()];
            }
            composedOf[cn++] = object;
        }
        graph.denyValue(resource);
        if (composedOf == null) {
            return;
        }
        int i = 0;
        while (i < cn) {
            void object = composedOf[i];
            Remover remover = null;
            if (useAdapters) {
                remover = (Remover)graph.getPossibleAdapter((Resource)object, Remover.class);
            }
            if (remover != null) {
                remover.remove(graph);
            } else {
                EntityRemover.remove(graph, (Resource)object, useAdapters);
            }
            ++i;
        }
    }
}

