/*******************************************************************************
 * Copyright (c) 2019 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.variable;

import org.simantics.db.Resource;

/**
 * An interface to match the VariableOrResource SCL data type
 * which represents either a Resource or a Variable. Allows
 * defining SCL classes with either of the two as a input.
 *
 * @author Antti Villberg
 * @since 1.40.0
 */
public interface VariableOrResource {

    public static VariableOrResource make(Resource value) {
        return new ResourceX(value);
    }
    
    public static VariableOrResource make(Variable value) {
        return new VariableX(value);
    }

    public static VariableOrResource make(Object value) {
        if(value instanceof Resource)
            return make((Resource)value);
        if(value instanceof Variable)
            return make((Variable)value);
        throw new IllegalArgumentException("VariableOrResource acccepts only Variable or Resource, got " + value + " with class " + value.getClass().getName());
    }

}
