package org.simantics.db.layer0.variable;

import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.NoSingleResultException;
import org.simantics.db.layer0.exception.MissingVariableValueException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardGraphResourcePropertyVariable extends StandardGraphPropertyVariable {

    private static final Logger LOGGER = LoggerFactory.getLogger(StandardGraphResourcePropertyVariable.class);

	public StandardGraphResourcePropertyVariable(ReadGraph graph, Variable parent, Resource parentResource, Resource property) throws DatabaseException {
	    super(graph, parent, null, parentResource, property);
	}

	@Override
	public <T> T getValue(ReadGraph graph) throws DatabaseException {
		if (parentResource == null)
			throw new MissingVariableValueException("Variable is not represented by any resource (URI=" + getPossibleURI(graph) + ").");
		try {
	        return (T)graph.getSingleObject(parentResource, property.predicate);
		} catch (NoSingleResultException e) {
			LOGGER.error("No object for " + parentResource + " " + property);
			throw new MissingVariableValueException(getPossibleURI(graph), e);
		} 
	}

	@Override
	public <T> T getValue(ReadGraph graph, Binding binding) throws DatabaseException {
		if (parentResource == null)
			throw new MissingVariableValueException("Variable is not represented by any resource (URI=" + getPossibleURI(graph) + ").");
		try {
            return (T)graph.getSingleObject(parentResource, property.predicate);
		} catch (NoSingleResultException e) {
			LOGGER.error("No object for " + parentResource + " " + property);
			throw new MissingVariableValueException(getPossibleURI(graph), e);
		} 
	}
	
	@Override
	public Datatype getDatatype(ReadGraph graph) throws DatabaseException {
	    return null;
	}
	
}
