package org.simantics.db.layer0.variable;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyVariables {

    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyVariables.class);

    public static Variable tryToOwn(ReadGraph graph, Variable parent, Variable variable) {
        if (variable instanceof ProxyVariableSupport) {
            ProxyVariableSupport pvs = (ProxyVariableSupport) variable;
            return pvs.attachTo(graph, parent);
        }
        return null;
    }

    public static Variable tryToOwnRenamed(ReadGraph graph, Variable parent, Variable variable, String name) {
        if (variable instanceof ProxyVariableSupport) {
            ProxyVariableSupport pvs = (ProxyVariableSupport) variable;
            return pvs.attachToRenamed(graph, parent, name);
        }
        return null;
    }

	public static Variable inputVariable(ReadGraph graph, Variable context) throws DatabaseException {
    	Variable session = graph.syncRequest(new ProxySessionRequest(context));
    	if(session == null) return null;
    	String uri = session.getPossiblePropertyValue(graph, "inputURI");
    	if(uri == null) {
    		// TODO HAXX - Please fix this
    		// we have no URI so this probably means that someone has inserted a non-session 
    		// into the proxy variable => return that instead
    		return session;
    	}
    	return Variables.getVariable(graph, uri);
	}

	public static Variable sessionVariable(ReadGraph graph, Variable self) throws DatabaseException {
		return graph.syncRequest(new ProxySessionRequest(self));
	}

	public static Variable makeProxyVariable(ReadGraph graph, Variable base, Variable input) throws DatabaseException {
		
    	base = base.getChild(graph, ProxyChildVariable.CONTEXT_BEGIN);
    	String path = input.getURI(graph).substring("http:/".length());
    	base = base.browse(graph, path);
    	return base.getChild(graph, ProxyChildVariable.CONTEXT_END);
    	
	}
	
    public static Variable proxySessionVariable(ReadGraph graph, Variable variable) throws DatabaseException {

        try {
            return proxyVariableInput(graph, variable);
        } catch (Throwable t) {
            LOGGER.error("proxySessionVariable failed", t);
            return null;
        }

    }

    public static Variable proxyVariableBase(ReadGraph graph, Variable variable) throws DatabaseException {
    	
    	try {
    		
    		Variable parent = variable.getParent(graph);
    		if(parent == null) return null;
    		
    		if(parent instanceof ProxyChildVariable) {
    			return ((ProxyChildVariable)parent).base();
    		} else {
    			return proxyVariableBase(graph, parent);
    		}
    		
        } catch (Throwable t) {
            LOGGER.error("proxyVariableBase failed", t);
            return null;
        }

    }

    public static Variable proxyVariableInput(ReadGraph graph, Variable variable) throws DatabaseException {

		if(variable instanceof ProxyChildVariable) {
			Variable var = ((ProxyChildVariable)variable).other();
			if(var.getParent(graph) == null) {
				return null;
			}
			return var;
		} else {
			Variable parent = variable.getParent(graph);
			if(parent == null) return null;
			else return proxyVariableInput(graph, parent);
		}
    	
    }
    
    public static Variable proxyVariableRoot(ReadGraph graph, Variable variable) throws DatabaseException {
    	
    	try {
    		
    		Variable parent = variable.getParent(graph);
    		if(parent == null) return null;
    		
    		if(parent instanceof ProxyChildVariable) {
    			return variable;
    		} else {
    			return proxyVariableRoot(graph, parent);
    		}
    		
        } catch (Throwable t) {
            LOGGER.error("proxyVariableRoot failed", t);
            return null;
        }

    }

    public static boolean isProxy(ReadGraph graph, Variable variable) throws DatabaseException {
    	return proxyVariableRoot(graph, variable) != null;
    }

}
