package org.simantics.db.layer0.variable;

import java.util.ArrayList;
import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;

public class ProxyChildVariable extends AbstractChildVariable {

	public static final String CONTEXT_BEGIN = ">>>";
	public static final String CONTEXT_END = "<<<";

	// This is the variable that shall be returned to
	protected final Variable base;
	// Actual parent of this variable
	protected final Variable parent;
	// This is the accumulated context variable that is queries for children
	protected final Variable other;
	protected final String name;
	
	public ProxyChildVariable(Variable base, Variable parent, Variable other, String name) {
		assert(base != null);
		assert(parent != null);
		assert(other != null);
		assert(name != null);
		this.base = base;
		this.parent = parent;
		this.other = other;
		this.name = name;
	}
	
	public Variable other() {
		return other;
	}
	
	public Variable base() {
		return base;
	}
	
	@Override
	public String getName(ReadGraph graph) throws DatabaseException {
		return name;
	}
	@Override
	public Variable getParent(ReadGraph graph) throws DatabaseException {
		return parent;
	}
	
    public Variable getPossibleChild(ReadGraph graph, String name) throws DatabaseException {
    	Variable otherChild = other.getPossibleChild(graph, name);
    	if(otherChild == null) return null;
    	return create(base, this, otherChild, name);
    }
    
    public Collection<Variable> getChildren(ReadGraph graph) throws DatabaseException {
    	
    	ArrayList<Variable> result = new ArrayList<Variable>();
    	Collection<Variable> otherChildren = other.browseChildren(graph);
    	for(Variable o : otherChildren) {
    		result.add(create(base, this, o, o.getName(graph)));
    	}
    	return result;
    	
    }
    
    public Variable getPossibleProperty(ReadGraph graph, String name) throws DatabaseException {
    	Variable otherChild = other.getPossibleProperty(graph, name);
    	if(otherChild == null) return null;
    	return create(base, this, otherChild, name);
    }

    public Variable create(Variable base, Variable parent, Variable other, String name) {
    	return new ProxyChildVariable(base, parent, other, name);
    }

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + (base != null ? base.hashCode() : 0);
		result = prime * result + (parent != null ? parent.hashCode() : 0);
		result = prime * result + (other != null ? other.hashCode() : 0);
		result = prime * result + (name != null ? name.hashCode() : 0);
		return result;
	}
    
	@Override
	public boolean equals(Object obj) {
		
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		
		ProxyChildVariable proxy = (ProxyChildVariable) obj;
		
        if(base != null) {
        	if(!base.equals(proxy.base)) return false;
        } else if (proxy.base != null) return false;
        
        if(parent != null) {
        	if(!parent.equals(proxy.parent)) return false;
        } else if (proxy.parent != null) return false;

        if(other != null) {
        	if(!other.equals(proxy.other)) return false;
        } else if (proxy.other != null) return false;

        if(name != null) {
        	if(!name.equals(proxy.name)) return false;
        } else if (proxy.name != null) return false;

        return true;
		
	}
    
}
