package org.simantics.db.layer0.util;

import java.util.Map;

import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.SimanticsClipboard.Representation;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.utils.datastructures.hints.IHintContext.Key;

class VariableRepresentation implements Representation {

	private String URI;
	
	public VariableRepresentation(String URI) {
		this.URI = URI;
	}

	@Override
	public Key getKey() {
		return SimanticsKeys.KEY_VARIABLE;
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public <T> T getValue(RequestProcessor processor, Map<String,Object> hints) throws DatabaseException {
		return (T)processor.syncRequest(new UniqueRead<Variable>() {
			@Override
			public Variable perform(ReadGraph graph) throws DatabaseException {
				return Variables.getVariable(graph, URI);
			}
		});
	}
	
}