package org.simantics.db.layer0.util;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.AdaptValue;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.OperationNotAllowedException;
import org.simantics.db.request.WriteResult;
import org.simantics.scl.runtime.function.Function;

public class Operations {

    public static boolean isAllowed(RequestProcessor rp, Resource operation) throws DatabaseException {
        return true;
    }
    
    public static <T> T exec(RequestProcessor rp, 
            Resource operation, Object ... parameters) throws DatabaseException, OperationNotAllowedException {
        if(!isAllowed(rp, operation))
            throw new OperationNotAllowedException();
        Object op = rp.syncRequest(new AdaptValue(operation));
        if(parameters.length > 0)
            op = ((Function)op).applyArray(parameters);
        return rp.syncRequest((WriteResult<T>)op);
    }
    
}
