/*******************************************************************************
 * Copyright (c) 2016 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.util;

import org.simantics.db.ReadGraph;
import org.simantics.db.Statement;
import org.simantics.db.layer0.util.DomainProcessor3.ExclusionDecision;
import org.simantics.layer0.Layer0;
import org.simantics.scl.runtime.function.Function1;

/**
 * @author Antti Villberg
 * @since 1.22
 */
public class GUIDExclusionFunction implements Function1<Statement, ExclusionDecision> {

	final private Layer0 L0;

	public GUIDExclusionFunction(ReadGraph graph) {
		L0 = Layer0.getInstance(graph);
	}

	@Override
	public ExclusionDecision apply(Statement p0) {
		if(L0.identifier.equals(p0.getPredicate()))
			return ExclusionDecision.EXCLUDE_OBJECT;
		else
			return ExclusionDecision.INCLUDE;
	}

}