/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.util;

import java.util.Collection;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.DirectStatements;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.service.DirectQuerySupport;
import org.simantics.db.service.StatementSupport;
import org.simantics.layer0.Layer0;

final public class DomainStatementProcedure implements AsyncProcedure<DirectStatements> {

	final private DirectQuerySupport dqs;
	final private StatementSupport s;
	final private Layer0 l0;
	final private Collection<DirectStatements>[] results;
	final private Collection<Resource>[] listElements;

	public DomainStatementProcedure(DirectQuerySupport dqs, StatementSupport s, Layer0 l0, Collection<DirectStatements>[] results, Collection<Resource>[] listElements) {
		this.dqs = dqs;
		this.s = s;
		this.l0 = l0;
		this.results = results;
		this.listElements = listElements;
	}

	@Override
	public void execute(AsyncReadGraph graph, final DirectStatements ds) {

		int thread = graph.thread();
		results[thread].add(ds);

		for(final Statement stm : ds) {

			if (s.isList(stm)) {

				graph.forIsSubrelationOf(stm.getPredicate(), l0.HasNext, new AsyncProcedure<Boolean>() {

					@Override
					public void execute(AsyncReadGraph graph, Boolean result) {

						if (result) {

							graph.forOrderedSet(stm.getSubject(),new AsyncMultiProcedure<Resource>() {

								@Override
								public void exception(AsyncReadGraph graph,Throwable throwable) {
									throwable.printStackTrace();
								}

								@Override
								public void execute(AsyncReadGraph graph, Resource item) {
									listElements[graph.thread()].add(item);
									//dqs.forEachDirectStatement(graph, item, DomainStatementProcedure.this);
								}

								@Override
								public void finished(AsyncReadGraph graph) {
								}

							});

						}

					}

					@Override
					public void exception(AsyncReadGraph graph,Throwable throwable) {
						throwable.printStackTrace();
					}

				});
				
			}

		}

	}

	@Override
	public void exception(AsyncReadGraph graph, Throwable throwable) {
		throwable.printStackTrace();
	}

}
