package org.simantics.db.layer0.util;

import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.internal.SimanticsInternal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseExceptionUtils {

    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseExceptionUtils.class);

    public static String showResource(Resource resource) {
        return showResource(SimanticsInternal.getSession(), resource);
    }

    public static String showResource(RequestProcessor processor, Resource resource) {
        try {
            return processor.syncRequest(new UniqueRead<String>() {

                @Override
                public String perform(ReadGraph graph) throws DatabaseException {
                    return NameUtils.getURIOrSafeNameInternal(graph, resource);
                }
            });
        } catch (DatabaseException e) {
            LOGGER.error("Unknown error while evaluating debug name for a resource " + resource, e);
            return resource.toString();
        }
    }

}
