package org.simantics.db.layer0.util;

import java.util.Map;

import org.simantics.databoard.container.DataContainer;
import org.simantics.db.RequestProcessor;
import org.simantics.db.layer0.util.SimanticsClipboard.Representation;
import org.simantics.utils.datastructures.hints.IHintContext.Key;

public class DataContainerRepresentation implements Representation {

	final private DataContainer value;
	
	public DataContainerRepresentation(DataContainer value) {
		this.value = value;
	}

	@Override
	public Key getKey() {
		return SimanticsKeys.KEY_DATA_CONTAINER;
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public <T> T getValue(RequestProcessor processor, Map<String,Object> hints) {
		return (T)value;
	}
	
}