package org.simantics.db.layer0.util;

import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.exception.DatabaseException;

public class ComposedTGValueModifier implements TGValueModifier {

	final TGValueModifier[] modifiers;
	
	public ComposedTGValueModifier(TGValueModifier[] modifiers) {
		this.modifiers = modifiers;
	}
	
	@Override
	public boolean mayNeedModification(Datatype type) throws DatabaseException {
		for(TGValueModifier mod : modifiers)
			if(mod.mayNeedModification(type))
				return true;
		return false;
	}

	@Override
	public Object modify(final DomainProcessorState state, Binding binding, Object value) throws DatabaseException {

		Datatype type = binding.type();
		
		for(TGValueModifier mod : modifiers)
			if(mod.mayNeedModification(type))
				value = mod.modify(state, binding, value);
		
		return value;
		
	}

}
