/*******************************************************************************
 * Copyright (c) 2016 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.request;

import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;

final public class VariableValueWithBinding<T> extends BinaryRead<Variable, Binding, T> {

    public VariableValueWithBinding(Variable variable, Binding binding) {
        super(variable, binding);
    }

    @Override
    public T perform(ReadGraph graph) throws DatabaseException {
        return parameter.getValue(graph, parameter2);
    }

}
