/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.request;

import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.exception.AssumptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableFactory;

public class VariableFactoryRequest extends BinaryRead<Variable, VariableFactory, Collection<Variable>> {

    public VariableFactoryRequest(Variable variable, VariableFactory factory) {
        super(variable, factory);
    	assert(variable != null);
    	assert(factory != null);
    }

    @Override
    public Collection<Variable> perform(ReadGraph graph) throws DatabaseException {
    	Collection<Variable> result = parameter2.evaluate(graph, parameter);
    	if(result == null) throw new AssumptionException("VariableFactory should not return null."); 
    	return result;
    }

}
