package org.simantics.db.layer0.request;

import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.NoSingleResultException;

/**
 * Returns the active model or null if no single active model is available.
 */
public class SingleActiveModel extends ResourceRead<Resource> {

    public SingleActiveModel(Resource project) {
        super(project);
    }

    @Override
    public Resource perform(ReadGraph graph) throws DatabaseException {
        Collection<Resource> actives = graph.syncRequest(new ActiveModels(resource));
        if (actives.size() == 1)
            return actives.iterator().next();

        if (actives.size() == 0) 
        	throw new NoSingleResultException("There are no active models.", actives.size()); 

      	throw new NoSingleResultException("There are many active models: " + NameUtils.getSafeName(graph, actives), actives.size()); 
        
    }

}
