package org.simantics.db.layer0.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.StandardGraphChildVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.layer0.Layer0;

public class ResourceToPossibleVariable extends ResourceRead<Variable> {

	public ResourceToPossibleVariable(Resource resource) {
		super(resource);
	}
	
	@Override
	public Variable perform(ReadGraph graph) throws DatabaseException {
		
		Layer0 L0 = Layer0.getInstance(graph);
		Resource parent = graph.getPossibleObject(resource, L0.PartOf);
		if(parent == null) {
			if(graph.getRootLibrary().equals(resource)) return new StandardGraphChildVariable(null, null, graph.getRootLibrary());
			else return null;
		}
		Variable parentVariable = graph.syncRequest(new ResourceToPossibleVariable(parent));
		if(parentVariable == null) return null;
		return parentVariable.browsePossible(graph, resource);
		
	}

}
