/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.request;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.common.exception.DebugException;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.exception.AdaptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.layer0.exception.MissingVariableException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableInterface;
import org.simantics.layer0.Layer0;
import org.simantics.scl.reflection.OntologyVersions;
import org.simantics.simulation.ontology.SimulationResource;

public class PossibleSessionVariable extends BinaryRead<ResourceArray, String, Variable> {

    public PossibleSessionVariable(ResourceArray resource, String identifier) {
        super(resource, identifier);
    }

    @Override
    public Variable perform(ReadGraph graph) throws DatabaseException {

        try {

        	String uri = OntologyVersions.getInstance().currentVersion("http://www.simantics.org/Modeling-0.0/CompositeToDiagram");
        	Resource map = graph.getResource(uri);

            Resource tail = parameter.tail();
            Resource head = parameter.head();

            if(!graph.hasStatement(tail)) return null;

            Layer0 l0 = Layer0.getInstance(graph);

            String valuationName = null;

            Resource diagram = graph.syncRequest(new PossibleDiagram(tail));
            if(diagram == null) {
                Resource d = diagram;
                while((d = graph.getPossibleObject(d, l0.PartOf)) != null) {
                    diagram = graph.getPossibleObject(d, map);
                    if(diagram != null) break;
                }
            }

            if(diagram != null) {
                SimulationResource SIMU = SimulationResource.getInstance(graph);
                for(Resource run : graph.getObjects(diagram, l0.ConsistsOf)) {
                    String name = graph.getPossibleRelatedValue(run, l0.HasName, Bindings.STRING);
                    if(parameter2.equals(name)) {
                        valuationName = graph.getPossibleRelatedValue(run, SIMU.HasActiveExperiment);
                        break;
                    }
                }
            }


            Resource model = graph.syncRequest(new PossibleModel(head));
            if (model == null) return null;

//            if(valuationName == null) {
//            	String valuation = graph.syncRequest(new PossibleActiveExperiment(model));
//            	if(valuation != null) valuationName = valuation;
//            }

            if (valuationName == null) {
                valuationName = "/ConfigurationValues";
            }

            VariableInterface variableInterface = graph.adapt(model, VariableInterface.class);
            Variable modelVariable = graph.adapt(model, Variable.class);
            Variable experimentVariable = modelVariable.browse(graph, valuationName);
            return variableInterface.getVariable(graph, experimentVariable, parameter);

        } catch (MissingVariableException e) {
            if (DebugException.DEBUG)
                e.printStackTrace();
            return null;
        } catch (ResourceNotFoundException e) {
            if (DebugException.DEBUG)
                e.printStackTrace();
            return null;
        } catch (AdaptionException e) {
            if (DebugException.DEBUG)
                e.printStackTrace();
            return null;
        } catch (Throwable e) {
            if (DebugException.DEBUG)
                e.printStackTrace();
            return null;
        }

    }


//    @Override
//    public Variable perform(ReadGraph graph) throws DatabaseException {
//
//    	try {
//
//        	Builtins b = graph.getBuiltins();
//        	String valuationName = null;
//        	//Valuations valuations = graph.adapt(parameter, Valuations.class);
//	        Resource map = graph.getResource("http://www.simantics.org/Modeling-1.1/CompositeToDiagram");
//
//	        Resource tail = parameter.resources[parameter.size() - 1];
//
//            Resource diagram = graph.syncRequest(new PossibleDiagram(tail));
//            if(diagram == null) {
//            	Resource d = diagram;
//				while((d = graph.getPossibleObject(d, b.PartOf)) != null) {
//					diagram = graph.getPossibleObject(d, map);
//					if(diagram != null) break;
//				}
//            }
//
//            if(diagram != null) {
//        		for(Resource run : graph.getObjects(diagram, b.ConsistsOf)) {
//        			String name = graph.getPossibleRelatedValue(run, b.HasName, StringJavaBinding.INSTANCE);
//        			if(parameter2.equals(name)) {
//                    	valuationName = graph.getPossibleRelatedValue(run, b.HasActiveExperiment);
//                    	break;
//        			}
//        		}
//            }
//
//            Resource model = graph.syncRequest(new PossibleModel(head));
//            if (model == null) return null;
//
//            if(valuationName == null) {
//            	String valuation = graph.syncRequest(new PossibleActiveExperiment(model));
//            	if(valuation != null) valuationName = valuation;
//            }
//
//            if (valuationName == null) {
//                valuationName = "/ConfigurationValues";
//            }
//
//            VariableInterface variableInterface = graph.adapt(model, VariableInterface.class);
//            Variable modelVariable = graph.adapt(model, Variable.class);
//            Variable experimentVariable = modelVariable.browse(graph, valuationName);
//            return variableInterface.getVariable(graph, experimentVariable, parameter);
//
////            return null;
//
////            Resource value = valuations.getValue(graph, null, valuationName, parameter3);
////            return graph.getSingleObject(value, b.ConsistsOf);
//
//        } catch (ResourceNotFoundException e) {
//            if (DebugException.DEBUG)
//                e.printStackTrace();
//            return null;
//        } catch (AdaptionException e) {
//            if (DebugException.DEBUG)
//                e.printStackTrace();
//            return null;
//        }
//
//    }

}
