/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.exception.DebugException;
import org.simantics.db.common.request.TernaryRead;
import org.simantics.db.exception.AdaptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.layer0.adapter.Valuations;

public class PossibleSelectedValuation extends TernaryRead<Resource, String, String, Resource> {

    public PossibleSelectedValuation(Resource resource, String valuation) {
        super(resource, valuation, "");
    }

    public PossibleSelectedValuation(Resource resource, String valuation, String suffix) {
        super(resource, valuation, suffix);
    }

    @Override
    public Resource perform(ReadGraph graph) throws DatabaseException {

        try {
            Valuations valuations = graph.adapt(parameter, Valuations.class);

            return valuations.getValue(graph, null, parameter2, parameter3);
            
        } catch (ResourceNotFoundException e) {
            if (DebugException.DEBUG)
                e.printStackTrace();
            return null;
        } catch (AdaptionException e) {
            if (DebugException.DEBUG)
                e.printStackTrace();
            return null;
        }

    }

}
