/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.common.exception.DebugException;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.AdaptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.layer0.exception.MissingVariableException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableInterface;
import org.simantics.layer0.Layer0;
import org.simantics.simulation.ontology.SimulationResource;

public class PossibleActiveVariable extends UnaryRead<ResourceArray, Variable> {

    public PossibleActiveVariable(ResourceArray resource) {
        super(resource);
    }

    @Override
    public Variable perform(ReadGraph graph) throws DatabaseException {

        try {

            Resource tail = parameter.tail();
            Resource head = parameter.head();

            if(!graph.hasStatement(tail)) return null;

        	Layer0 L0 = Layer0.getInstance(graph);
            SimulationResource SIMU = SimulationResource.getInstance(graph);

            String valuationName = null;

            //Valuations valuations = graph.adapt(parameter, Valuations.class);

            Resource diagram = graph.syncRequest(new PossibleDiagram(tail));
            if(diagram != null) {

                String valuation = graph.getPossibleRelatedValue(diagram, SIMU.HasActiveExperiment);
                if(valuation != null) valuationName = valuation;

            }

            Resource model = graph.syncRequest(new PossibleModel(head));
            if (model == null) return null;

            if(valuationName == null) {
                String valuation = graph.syncRequest(new PossibleActiveExperimentPath(model));
                if(valuation != null) valuationName = valuation;
            }

            if (valuationName == null) {
                valuationName = "/BaseRealization";
            }

            VariableInterface variableInterface = graph.adapt(model, VariableInterface.class);
            Variable modelVariable = graph.adapt(model, Variable.class);
            Variable experimentVariable = modelVariable.browse(graph, valuationName);
            return variableInterface.getVariable(graph, experimentVariable, parameter);

        } catch (MissingVariableException e) {
            if (DebugException.DEBUG)
                e.printStackTrace();
            return null;
        } catch (ResourceNotFoundException e) {
            if (DebugException.DEBUG)
                e.printStackTrace();
            return null;
        } catch (AdaptionException e) {
            if (DebugException.DEBUG)
                e.printStackTrace();
            return null;
        } catch (Throwable e) {
            if (DebugException.DEBUG)
                e.printStackTrace();
            return null;
        }

    }

}
