/*******************************************************************************
 * Copyright (c) 2023 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.layer0.Layer0;
import org.simantics.simulation.ontology.SimulationResource;

/**
 * @author Tuukka Lehtonen
 * @since 1.58.0
 */
public class PossibleActiveRunOfModel extends ResourceRead<Resource> {

	public PossibleActiveRunOfModel(Resource model) {
		super(model);
	}

	public PossibleActiveRunOfModel(ReadGraph graph, Variable model) throws DatabaseException {
		super(model.getRepresents(graph));
	}

	@Override
	public Resource perform(ReadGraph graph) throws DatabaseException {
		Layer0 b = Layer0.getInstance(graph);
		SimulationResource SIMU = SimulationResource.getInstance(graph);
		Resource result = null;

		for (Resource experiment : graph.syncRequest(new ObjectsWithType(resource, b.ConsistsOf, SIMU.Experiment))) {
			for (Resource run : graph.syncRequest(new ObjectsWithType(experiment, b.ConsistsOf, SIMU.Run))) {
				if (graph.hasStatement(run, SIMU.IsActive)) {
					if (result != null)
						return null;
					result = run;
				}
			}
		}

		return result;
	}

}