/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.exception.DatabaseException;

public class PossibleActiveModelValue<T> extends BinaryRead<Resource, String, T> {

    public PossibleActiveModelValue(Resource resource, String suffix) {
        super(resource, suffix);
    }

    @Override
    public T perform(ReadGraph graph) throws DatabaseException {
    	
		Resource valuation = graph.syncRequest(new PossibleActiveModelValuation(parameter, parameter2));
		if(valuation == null) {
			return null;
		}

		return (T)graph.getPossibleValue(valuation);

    }

}
